import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultApproleAuthBackendRoleIdConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#backend DataVaultApproleAuthBackendRoleId#backend}
    */
    readonly backend?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#role_name DataVaultApproleAuthBackendRoleId#role_name}
    */
    readonly roleName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id vault_approle_auth_backend_role_id}
*/
export declare class DataVaultApproleAuthBackendRoleId extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_approle_auth_backend_role_id";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id vault_approle_auth_backend_role_id} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultApproleAuthBackendRoleIdConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultApproleAuthBackendRoleIdConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get id(): string;
    get roleId(): string;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-approle-auth-backend-role-id.d.ts.map