import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultAdAccessCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * AD Secret Backend to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#backend DataVaultAdAccessCredentials#backend}
    */
    readonly backend: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#role DataVaultAdAccessCredentials#role}
    */
    readonly role: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials vault_ad_access_credentials}
*/
export declare class DataVaultAdAccessCredentials extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_ad_access_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials vault_ad_access_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAdAccessCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultAdAccessCredentialsConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get currentPassword(): string;
    get id(): string;
    get lastPassword(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get username(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-ad-access-credentials.d.ts.map