import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsulSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the address of the Consul instance, provided as "host:port" like "127.0.0.1:8500".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#address ConsulSecretBackend#address}
    */
    readonly address: string;
    /**
    * CA certificate to use when verifying Consul server certificate, must be x509 PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#ca_cert ConsulSecretBackend#ca_cert}
    */
    readonly caCert?: string;
    /**
    * Client certificate used for Consul's TLS communication, must be x509 PEM encoded and if this is set you need to also set client_key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#client_cert ConsulSecretBackend#client_cert}
    */
    readonly clientCert?: string;
    /**
    * Client key used for Consul's TLS communication, must be x509 PEM encoded and if this is set you need to also set client_cert.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#client_key ConsulSecretBackend#client_key}
    */
    readonly clientKey?: string;
    /**
    * Default lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#default_lease_ttl_seconds ConsulSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#description ConsulSecretBackend#description}
    */
    readonly description?: string;
    /**
    * Specifies if the secret backend is local only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#local ConsulSecretBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum possible lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#max_lease_ttl_seconds ConsulSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Unique name of the Vault Consul mount to configure
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#path ConsulSecretBackend#path}
    */
    readonly path?: string;
    /**
    * Specifies the URL scheme to use. Defaults to "http".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#scheme ConsulSecretBackend#scheme}
    */
    readonly scheme?: string;
    /**
    * Specifies the Consul ACL token to use. This must be a management type token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend#token ConsulSecretBackend#token}
    */
    readonly token: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend vault_consul_secret_backend}
*/
export declare class ConsulSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_consul_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend vault_consul_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsulSecretBackendConfig
    */
    constructor(scope: Construct, id: string, config: ConsulSecretBackendConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _caCert?;
    get caCert(): string;
    set caCert(value: string);
    resetCaCert(): void;
    get caCertInput(): string | undefined;
    private _clientCert?;
    get clientCert(): string;
    set clientCert(value: string);
    resetClientCert(): void;
    get clientCertInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=consul-secret-backend.d.ts.map