import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_common_names CertAuthBackendRole#allowed_common_names}
    */
    readonly allowedCommonNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_dns_sans CertAuthBackendRole#allowed_dns_sans}
    */
    readonly allowedDnsSans?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_email_sans CertAuthBackendRole#allowed_email_sans}
    */
    readonly allowedEmailSans?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_names CertAuthBackendRole#allowed_names}
    */
    readonly allowedNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_organization_units CertAuthBackendRole#allowed_organization_units}
    */
    readonly allowedOrganizationUnits?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#allowed_uri_sans CertAuthBackendRole#allowed_uri_sans}
    */
    readonly allowedUriSans?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#backend CertAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#certificate CertAuthBackendRole#certificate}
    */
    readonly certificate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#display_name CertAuthBackendRole#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#name CertAuthBackendRole#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#required_extensions CertAuthBackendRole#required_extensions}
    */
    readonly requiredExtensions?: string[];
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_bound_cidrs CertAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_explicit_max_ttl CertAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_max_ttl CertAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_no_default_policy CertAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_num_uses CertAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_period CertAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_policies CertAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_ttl CertAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role#token_type CertAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role vault_cert_auth_backend_role}
*/
export declare class CertAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_cert_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/cert_auth_backend_role vault_cert_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: CertAuthBackendRoleConfig);
    private _allowedCommonNames?;
    get allowedCommonNames(): string[];
    set allowedCommonNames(value: string[]);
    resetAllowedCommonNames(): void;
    get allowedCommonNamesInput(): string[] | undefined;
    private _allowedDnsSans?;
    get allowedDnsSans(): string[];
    set allowedDnsSans(value: string[]);
    resetAllowedDnsSans(): void;
    get allowedDnsSansInput(): string[] | undefined;
    private _allowedEmailSans?;
    get allowedEmailSans(): string[];
    set allowedEmailSans(value: string[]);
    resetAllowedEmailSans(): void;
    get allowedEmailSansInput(): string[] | undefined;
    private _allowedNames?;
    get allowedNames(): string[];
    set allowedNames(value: string[]);
    resetAllowedNames(): void;
    get allowedNamesInput(): string[] | undefined;
    private _allowedOrganizationUnits?;
    get allowedOrganizationUnits(): string[];
    set allowedOrganizationUnits(value: string[]);
    resetAllowedOrganizationUnits(): void;
    get allowedOrganizationUnitsInput(): string[] | undefined;
    private _allowedUriSans?;
    get allowedUriSans(): string[];
    set allowedUriSans(value: string[]);
    resetAllowedUriSans(): void;
    get allowedUriSansInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requiredExtensions?;
    get requiredExtensions(): string[];
    set requiredExtensions(value: string[]);
    resetRequiredExtensions(): void;
    get requiredExtensionsInput(): string[] | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cert-auth-backend-role.d.ts.map