import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application Object ID for an existing service principal that will be used instead of creating dynamic service principals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#application_object_id AzureSecretBackendRole#application_object_id}
    */
    readonly applicationObjectId?: string;
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#backend AzureSecretBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#description AzureSecretBackendRole#description}
    */
    readonly description?: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#max_ttl AzureSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Name of the role to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#role AzureSecretBackendRole#role}
    */
    readonly role: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#ttl AzureSecretBackendRole#ttl}
    */
    readonly ttl?: string;
    /**
    * azure_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#azure_groups AzureSecretBackendRole#azure_groups}
    */
    readonly azureGroups?: AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable;
    /**
    * azure_roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#azure_roles AzureSecretBackendRole#azure_roles}
    */
    readonly azureRoles?: AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable;
}
export interface AzureSecretBackendRoleAzureGroups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#group_name AzureSecretBackendRole#group_name}
    */
    readonly groupName: string;
}
export declare function azureSecretBackendRoleAzureGroupsToTerraform(struct?: AzureSecretBackendRoleAzureGroups | cdktf.IResolvable): any;
export interface AzureSecretBackendRoleAzureRoles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#role_name AzureSecretBackendRole#role_name}
    */
    readonly roleName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#scope AzureSecretBackendRole#scope}
    */
    readonly scope: string;
}
export declare function azureSecretBackendRoleAzureRolesToTerraform(struct?: AzureSecretBackendRoleAzureRoles | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role vault_azure_secret_backend_role}
*/
export declare class AzureSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_azure_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role vault_azure_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: AzureSecretBackendRoleConfig);
    private _applicationObjectId?;
    get applicationObjectId(): string;
    set applicationObjectId(value: string);
    resetApplicationObjectId(): void;
    get applicationObjectIdInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _azureGroups?;
    get azureGroups(): AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable;
    set azureGroups(value: AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable);
    resetAzureGroups(): void;
    get azureGroupsInput(): cdktf.IResolvable | AzureSecretBackendRoleAzureGroups[] | undefined;
    private _azureRoles?;
    get azureRoles(): AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable;
    set azureRoles(value: AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable);
    resetAzureRoles(): void;
    get azureRolesInput(): cdktf.IResolvable | AzureSecretBackendRoleAzureRoles[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=azure-secret-backend-role.d.ts.map