"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsSecretBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role vault_aws_secret_backend_role}
*/
class AwsSecretBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role vault_aws_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsSecretBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_aws_secret_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._backend = config.backend;
        this._credentialType = config.credentialType;
        this._defaultStsTtl = config.defaultStsTtl;
        this._iamGroups = config.iamGroups;
        this._maxStsTtl = config.maxStsTtl;
        this._name = config.name;
        this._permissionsBoundaryArn = config.permissionsBoundaryArn;
        this._policyArns = config.policyArns;
        this._policyDocument = config.policyDocument;
        this._roleArns = config.roleArns;
        this._userPath = config.userPath;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get credentialType() {
        return this.getStringAttribute('credential_type');
    }
    set credentialType(value) {
        this._credentialType = value;
    }
    // Temporarily expose input value. Use with caution.
    get credentialTypeInput() {
        return this._credentialType;
    }
    get defaultStsTtl() {
        return this.getNumberAttribute('default_sts_ttl');
    }
    set defaultStsTtl(value) {
        this._defaultStsTtl = value;
    }
    resetDefaultStsTtl() {
        this._defaultStsTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultStsTtlInput() {
        return this._defaultStsTtl;
    }
    get iamGroups() {
        return cdktf.Fn.tolist(this.getListAttribute('iam_groups'));
    }
    set iamGroups(value) {
        this._iamGroups = value;
    }
    resetIamGroups() {
        this._iamGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamGroupsInput() {
        return this._iamGroups;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get maxStsTtl() {
        return this.getNumberAttribute('max_sts_ttl');
    }
    set maxStsTtl(value) {
        this._maxStsTtl = value;
    }
    resetMaxStsTtl() {
        this._maxStsTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxStsTtlInput() {
        return this._maxStsTtl;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get permissionsBoundaryArn() {
        return this.getStringAttribute('permissions_boundary_arn');
    }
    set permissionsBoundaryArn(value) {
        this._permissionsBoundaryArn = value;
    }
    resetPermissionsBoundaryArn() {
        this._permissionsBoundaryArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get permissionsBoundaryArnInput() {
        return this._permissionsBoundaryArn;
    }
    get policyArns() {
        return cdktf.Fn.tolist(this.getListAttribute('policy_arns'));
    }
    set policyArns(value) {
        this._policyArns = value;
    }
    resetPolicyArns() {
        this._policyArns = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get policyArnsInput() {
        return this._policyArns;
    }
    get policyDocument() {
        return this.getStringAttribute('policy_document');
    }
    set policyDocument(value) {
        this._policyDocument = value;
    }
    resetPolicyDocument() {
        this._policyDocument = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get policyDocumentInput() {
        return this._policyDocument;
    }
    get roleArns() {
        return cdktf.Fn.tolist(this.getListAttribute('role_arns'));
    }
    set roleArns(value) {
        this._roleArns = value;
    }
    resetRoleArns() {
        this._roleArns = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleArnsInput() {
        return this._roleArns;
    }
    get userPath() {
        return this.getStringAttribute('user_path');
    }
    set userPath(value) {
        this._userPath = value;
    }
    resetUserPath() {
        this._userPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPathInput() {
        return this._userPath;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            credential_type: cdktf.stringToTerraform(this._credentialType),
            default_sts_ttl: cdktf.numberToTerraform(this._defaultStsTtl),
            iam_groups: cdktf.listMapper(cdktf.stringToTerraform)(this._iamGroups),
            max_sts_ttl: cdktf.numberToTerraform(this._maxStsTtl),
            name: cdktf.stringToTerraform(this._name),
            permissions_boundary_arn: cdktf.stringToTerraform(this._permissionsBoundaryArn),
            policy_arns: cdktf.listMapper(cdktf.stringToTerraform)(this._policyArns),
            policy_document: cdktf.stringToTerraform(this._policyDocument),
            role_arns: cdktf.listMapper(cdktf.stringToTerraform)(this._roleArns),
            user_path: cdktf.stringToTerraform(this._userPath),
        };
    }
}
exports.AwsSecretBackendRole = AwsSecretBackendRole;
_a = JSII_RTTI_SYMBOL_1;
AwsSecretBackendRole[_a] = { fqn: "hashicorp_vault.AwsSecretBackendRole", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
AwsSecretBackendRole.tfResourceType = "vault_aws_secret_backend_role";
//# sourceMappingURL=data:application/json;base64,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