import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendRoletagBlacklistConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_roletag_blacklist#backend AwsAuthBackendRoletagBlacklist#backend}
    */
    readonly backend: string;
    /**
    * If true, disables the periodic tidying of the roletag blacklist entries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_roletag_blacklist#disable_periodic_tidy AwsAuthBackendRoletagBlacklist#disable_periodic_tidy}
    */
    readonly disablePeriodicTidy?: boolean | cdktf.IResolvable;
    /**
    * The amount of extra time that must have passed beyond the roletag expiration, before it's removed from backend storage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_roletag_blacklist#safety_buffer AwsAuthBackendRoletagBlacklist#safety_buffer}
    */
    readonly safetyBuffer?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_roletag_blacklist vault_aws_auth_backend_roletag_blacklist}
*/
export declare class AwsAuthBackendRoletagBlacklist extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_roletag_blacklist";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_roletag_blacklist vault_aws_auth_backend_roletag_blacklist} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendRoletagBlacklistConfig
    */
    constructor(scope: Construct, id: string, config: AwsAuthBackendRoletagBlacklistConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _disablePeriodicTidy?;
    get disablePeriodicTidy(): boolean | cdktf.IResolvable;
    set disablePeriodicTidy(value: boolean | cdktf.IResolvable);
    resetDisablePeriodicTidy(): void;
    get disablePeriodicTidyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _safetyBuffer?;
    get safetyBuffer(): number;
    set safetyBuffer(value: number);
    resetSafetyBuffer(): void;
    get safetyBufferInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=aws-auth-backend-roletag-blacklist.d.ts.map