import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * When true, allows migration of the underlying instance where the client resides. Use with caution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#allow_instance_migration AwsAuthBackendRole#allow_instance_migration}
    */
    readonly allowInstanceMigration?: boolean | cdktf.IResolvable;
    /**
    * The auth type permitted for this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#auth_type AwsAuthBackendRole#auth_type}
    */
    readonly authType?: string;
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#backend AwsAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Only EC2 instances with this account ID in their identity document will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_account_ids AwsAuthBackendRole#bound_account_ids}
    */
    readonly boundAccountIds?: string[];
    /**
    * Only EC2 instances using this AMI ID will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_ami_ids AwsAuthBackendRole#bound_ami_ids}
    */
    readonly boundAmiIds?: string[];
    /**
    * Only EC2 instances that match this instance ID will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_ec2_instance_ids AwsAuthBackendRole#bound_ec2_instance_ids}
    */
    readonly boundEc2InstanceIds?: string[];
    /**
    * Only EC2 instances associated with an IAM instance profile ARN that matches this value will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_iam_instance_profile_arns AwsAuthBackendRole#bound_iam_instance_profile_arns}
    */
    readonly boundIamInstanceProfileArns?: string[];
    /**
    * The IAM principal that must be authenticated using the iam auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_iam_principal_arns AwsAuthBackendRole#bound_iam_principal_arns}
    */
    readonly boundIamPrincipalArns?: string[];
    /**
    * Only EC2 instances that match this IAM role ARN will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_iam_role_arns AwsAuthBackendRole#bound_iam_role_arns}
    */
    readonly boundIamRoleArns?: string[];
    /**
    * Only EC2 instances in this region will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_regions AwsAuthBackendRole#bound_regions}
    */
    readonly boundRegions?: string[];
    /**
    * Only EC2 instances associated with this subnet ID will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_subnet_ids AwsAuthBackendRole#bound_subnet_ids}
    */
    readonly boundSubnetIds?: string[];
    /**
    * Only EC2 instances associated with this VPC ID will be permitted to log in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#bound_vpc_ids AwsAuthBackendRole#bound_vpc_ids}
    */
    readonly boundVpcIds?: string[];
    /**
    * When true, only allows a single token to be granted per instance ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#disallow_reauthentication AwsAuthBackendRole#disallow_reauthentication}
    */
    readonly disallowReauthentication?: boolean | cdktf.IResolvable;
    /**
    * The region to search for the inferred entities in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#inferred_aws_region AwsAuthBackendRole#inferred_aws_region}
    */
    readonly inferredAwsRegion?: string;
    /**
    * The type of inferencing Vault should do.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#inferred_entity_type AwsAuthBackendRole#inferred_entity_type}
    */
    readonly inferredEntityType?: string;
    /**
    * Whether or not Vault should resolve the bound_iam_principal_arn to an AWS Unique ID. When true, deleting a principal and recreating it with the same name won't automatically grant the new principal the same roles in Vault that the old principal had.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#resolve_aws_unique_ids AwsAuthBackendRole#resolve_aws_unique_ids}
    */
    readonly resolveAwsUniqueIds?: boolean | cdktf.IResolvable;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#role AwsAuthBackendRole#role}
    */
    readonly role: string;
    /**
    * The key of the tag on EC2 instance to use for role tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#role_tag AwsAuthBackendRole#role_tag}
    */
    readonly roleTag?: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_bound_cidrs AwsAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_explicit_max_ttl AwsAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_max_ttl AwsAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_no_default_policy AwsAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_num_uses AwsAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_period AwsAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_policies AwsAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_ttl AwsAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role#token_type AwsAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role vault_aws_auth_backend_role}
*/
export declare class AwsAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role vault_aws_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: AwsAuthBackendRoleConfig);
    private _allowInstanceMigration?;
    get allowInstanceMigration(): boolean | cdktf.IResolvable;
    set allowInstanceMigration(value: boolean | cdktf.IResolvable);
    resetAllowInstanceMigration(): void;
    get allowInstanceMigrationInput(): boolean | cdktf.IResolvable | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _boundAccountIds?;
    get boundAccountIds(): string[];
    set boundAccountIds(value: string[]);
    resetBoundAccountIds(): void;
    get boundAccountIdsInput(): string[] | undefined;
    private _boundAmiIds?;
    get boundAmiIds(): string[];
    set boundAmiIds(value: string[]);
    resetBoundAmiIds(): void;
    get boundAmiIdsInput(): string[] | undefined;
    private _boundEc2InstanceIds?;
    get boundEc2InstanceIds(): string[];
    set boundEc2InstanceIds(value: string[]);
    resetBoundEc2InstanceIds(): void;
    get boundEc2InstanceIdsInput(): string[] | undefined;
    private _boundIamInstanceProfileArns?;
    get boundIamInstanceProfileArns(): string[];
    set boundIamInstanceProfileArns(value: string[]);
    resetBoundIamInstanceProfileArns(): void;
    get boundIamInstanceProfileArnsInput(): string[] | undefined;
    private _boundIamPrincipalArns?;
    get boundIamPrincipalArns(): string[];
    set boundIamPrincipalArns(value: string[]);
    resetBoundIamPrincipalArns(): void;
    get boundIamPrincipalArnsInput(): string[] | undefined;
    private _boundIamRoleArns?;
    get boundIamRoleArns(): string[];
    set boundIamRoleArns(value: string[]);
    resetBoundIamRoleArns(): void;
    get boundIamRoleArnsInput(): string[] | undefined;
    private _boundRegions?;
    get boundRegions(): string[];
    set boundRegions(value: string[]);
    resetBoundRegions(): void;
    get boundRegionsInput(): string[] | undefined;
    private _boundSubnetIds?;
    get boundSubnetIds(): string[];
    set boundSubnetIds(value: string[]);
    resetBoundSubnetIds(): void;
    get boundSubnetIdsInput(): string[] | undefined;
    private _boundVpcIds?;
    get boundVpcIds(): string[];
    set boundVpcIds(value: string[]);
    resetBoundVpcIds(): void;
    get boundVpcIdsInput(): string[] | undefined;
    private _disallowReauthentication?;
    get disallowReauthentication(): boolean | cdktf.IResolvable;
    set disallowReauthentication(value: boolean | cdktf.IResolvable);
    resetDisallowReauthentication(): void;
    get disallowReauthenticationInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _inferredAwsRegion?;
    get inferredAwsRegion(): string;
    set inferredAwsRegion(value: string);
    resetInferredAwsRegion(): void;
    get inferredAwsRegionInput(): string | undefined;
    private _inferredEntityType?;
    get inferredEntityType(): string;
    set inferredEntityType(value: string);
    resetInferredEntityType(): void;
    get inferredEntityTypeInput(): string | undefined;
    private _resolveAwsUniqueIds?;
    get resolveAwsUniqueIds(): boolean | cdktf.IResolvable;
    set resolveAwsUniqueIds(value: boolean | cdktf.IResolvable);
    resetResolveAwsUniqueIds(): void;
    get resolveAwsUniqueIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get roleId(): string;
    private _roleTag?;
    get roleTag(): string;
    set roleTag(value: string);
    resetRoleTag(): void;
    get roleTagInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=aws-auth-backend-role.d.ts.map