"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsAuthBackendRoleTag = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag vault_aws_auth_backend_role_tag}
*/
class AwsAuthBackendRoleTag extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag vault_aws_auth_backend_role_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendRoleTagConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_aws_auth_backend_role_tag',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowInstanceMigration = config.allowInstanceMigration;
        this._backend = config.backend;
        this._disallowReauthentication = config.disallowReauthentication;
        this._instanceId = config.instanceId;
        this._maxTtl = config.maxTtl;
        this._policies = config.policies;
        this._role = config.role;
    }
    get allowInstanceMigration() {
        return this.getBooleanAttribute('allow_instance_migration');
    }
    set allowInstanceMigration(value) {
        this._allowInstanceMigration = value;
    }
    resetAllowInstanceMigration() {
        this._allowInstanceMigration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowInstanceMigrationInput() {
        return this._allowInstanceMigration;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get disallowReauthentication() {
        return this.getBooleanAttribute('disallow_reauthentication');
    }
    set disallowReauthentication(value) {
        this._disallowReauthentication = value;
    }
    resetDisallowReauthentication() {
        this._disallowReauthentication = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disallowReauthenticationInput() {
        return this._disallowReauthentication;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get instanceId() {
        return this.getStringAttribute('instance_id');
    }
    set instanceId(value) {
        this._instanceId = value;
    }
    resetInstanceId() {
        this._instanceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceIdInput() {
        return this._instanceId;
    }
    get maxTtl() {
        return this.getStringAttribute('max_ttl');
    }
    set maxTtl(value) {
        this._maxTtl = value;
    }
    resetMaxTtl() {
        this._maxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTtlInput() {
        return this._maxTtl;
    }
    get policies() {
        return cdktf.Fn.tolist(this.getListAttribute('policies'));
    }
    set policies(value) {
        this._policies = value;
    }
    resetPolicies() {
        this._policies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get policiesInput() {
        return this._policies;
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    // tag_key - computed: true, optional: false, required: false
    get tagKey() {
        return this.getStringAttribute('tag_key');
    }
    // tag_value - computed: true, optional: false, required: false
    get tagValue() {
        return this.getStringAttribute('tag_value');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_instance_migration: cdktf.booleanToTerraform(this._allowInstanceMigration),
            backend: cdktf.stringToTerraform(this._backend),
            disallow_reauthentication: cdktf.booleanToTerraform(this._disallowReauthentication),
            instance_id: cdktf.stringToTerraform(this._instanceId),
            max_ttl: cdktf.stringToTerraform(this._maxTtl),
            policies: cdktf.listMapper(cdktf.stringToTerraform)(this._policies),
            role: cdktf.stringToTerraform(this._role),
        };
    }
}
exports.AwsAuthBackendRoleTag = AwsAuthBackendRoleTag;
_a = JSII_RTTI_SYMBOL_1;
AwsAuthBackendRoleTag[_a] = { fqn: "hashicorp_vault.AwsAuthBackendRoleTag", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
AwsAuthBackendRoleTag.tfResourceType = "vault_aws_auth_backend_role_tag";
//# sourceMappingURL=data:application/json;base64,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