import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendLoginConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS Auth Backend to read the token from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#backend AwsAuthBackendLogin#backend}
    */
    readonly backend?: string;
    /**
    * The HTTP method used in the signed request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#iam_http_request_method AwsAuthBackendLogin#iam_http_request_method}
    */
    readonly iamHttpRequestMethod?: string;
    /**
    * The Base64-encoded body of the signed request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#iam_request_body AwsAuthBackendLogin#iam_request_body}
    */
    readonly iamRequestBody?: string;
    /**
    * The Base64-encoded, JSON serialized representation of the sts:GetCallerIdentity HTTP request headers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#iam_request_headers AwsAuthBackendLogin#iam_request_headers}
    */
    readonly iamRequestHeaders?: string;
    /**
    * The Base64-encoded HTTP URL used in the signed request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#iam_request_url AwsAuthBackendLogin#iam_request_url}
    */
    readonly iamRequestUrl?: string;
    /**
    * Base64-encoded EC2 instance identity document to authenticate with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#identity AwsAuthBackendLogin#identity}
    */
    readonly identity?: string;
    /**
    * The nonce to be used for subsequent login requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#nonce AwsAuthBackendLogin#nonce}
    */
    readonly nonce?: string;
    /**
    * PKCS7 signature of the identity document to authenticate with, with all newline characters removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#pkcs7 AwsAuthBackendLogin#pkcs7}
    */
    readonly pkcs7?: string;
    /**
    * AWS Auth Role to read the token from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#role AwsAuthBackendLogin#role}
    */
    readonly role?: string;
    /**
    * Base64-encoded SHA256 RSA signature of the instance identtiy document to authenticate with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login#signature AwsAuthBackendLogin#signature}
    */
    readonly signature?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login vault_aws_auth_backend_login}
*/
export declare class AwsAuthBackendLogin extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_login";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login vault_aws_auth_backend_login} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendLoginConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AwsAuthBackendLoginConfig);
    get accessor(): string;
    get authType(): string;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get clientToken(): string;
    private _iamHttpRequestMethod?;
    get iamHttpRequestMethod(): string;
    set iamHttpRequestMethod(value: string);
    resetIamHttpRequestMethod(): void;
    get iamHttpRequestMethodInput(): string | undefined;
    private _iamRequestBody?;
    get iamRequestBody(): string;
    set iamRequestBody(value: string);
    resetIamRequestBody(): void;
    get iamRequestBodyInput(): string | undefined;
    private _iamRequestHeaders?;
    get iamRequestHeaders(): string;
    set iamRequestHeaders(value: string);
    resetIamRequestHeaders(): void;
    get iamRequestHeadersInput(): string | undefined;
    private _iamRequestUrl?;
    get iamRequestUrl(): string;
    set iamRequestUrl(value: string);
    resetIamRequestUrl(): void;
    get iamRequestUrlInput(): string | undefined;
    get id(): string;
    private _identity?;
    get identity(): string;
    set identity(value: string);
    resetIdentity(): void;
    get identityInput(): string | undefined;
    get leaseDuration(): number;
    get leaseStartTime(): string;
    metadata(key: string): string | cdktf.IResolvable;
    private _nonce?;
    get nonce(): string;
    set nonce(value: string);
    resetNonce(): void;
    get nonceInput(): string | undefined;
    private _pkcs7?;
    get pkcs7(): string;
    set pkcs7(value: string);
    resetPkcs7(): void;
    get pkcs7Input(): string | undefined;
    get policies(): string[];
    get renewable(): cdktf.IResolvable;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _signature?;
    get signature(): string;
    set signature(value: string);
    resetSignature(): void;
    get signatureInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=aws-auth-backend-login.d.ts.map