import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS Access key with permissions to query AWS APIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#access_key AwsAuthBackendClient#access_key}
    */
    readonly accessKey?: string;
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#backend AwsAuthBackendClient#backend}
    */
    readonly backend?: string;
    /**
    * URL to override the default generated endpoint for making AWS EC2 API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#ec2_endpoint AwsAuthBackendClient#ec2_endpoint}
    */
    readonly ec2Endpoint?: string;
    /**
    * URL to override the default generated endpoint for making AWS IAM API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#iam_endpoint AwsAuthBackendClient#iam_endpoint}
    */
    readonly iamEndpoint?: string;
    /**
    * The value to require in the X-Vault-AWS-IAM-Server-ID header as part of GetCallerIdentity requests that are used in the iam auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#iam_server_id_header_value AwsAuthBackendClient#iam_server_id_header_value}
    */
    readonly iamServerIdHeaderValue?: string;
    /**
    * AWS Secret key with permissions to query AWS APIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#secret_key AwsAuthBackendClient#secret_key}
    */
    readonly secretKey?: string;
    /**
    * URL to override the default generated endpoint for making AWS STS API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#sts_endpoint AwsAuthBackendClient#sts_endpoint}
    */
    readonly stsEndpoint?: string;
    /**
    * Region to override the default region for making AWS STS API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client#sts_region AwsAuthBackendClient#sts_region}
    */
    readonly stsRegion?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client vault_aws_auth_backend_client}
*/
export declare class AwsAuthBackendClient extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_client";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_client vault_aws_auth_backend_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendClientConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AwsAuthBackendClientConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _ec2Endpoint?;
    get ec2Endpoint(): string;
    set ec2Endpoint(value: string);
    resetEc2Endpoint(): void;
    get ec2EndpointInput(): string | undefined;
    private _iamEndpoint?;
    get iamEndpoint(): string;
    set iamEndpoint(value: string);
    resetIamEndpoint(): void;
    get iamEndpointInput(): string | undefined;
    private _iamServerIdHeaderValue?;
    get iamServerIdHeaderValue(): string;
    set iamServerIdHeaderValue(value: string);
    resetIamServerIdHeaderValue(): void;
    get iamServerIdHeaderValueInput(): string | undefined;
    get id(): string;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _stsEndpoint?;
    get stsEndpoint(): string;
    set stsEndpoint(value: string);
    resetStsEndpoint(): void;
    get stsEndpointInput(): string | undefined;
    private _stsRegion?;
    get stsRegion(): string;
    set stsRegion(value: string);
    resetStsRegion(): void;
    get stsRegionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=aws-auth-backend-client.d.ts.map