import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#description AuthBackend#description}
    */
    readonly description?: string;
    /**
    * Specifies if the auth method is local only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#local AuthBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * path to mount the backend. This defaults to the type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#path AuthBackend#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#tune AuthBackend#tune}
    */
    readonly tune?: AuthBackendTune[] | cdktf.IResolvable;
    /**
    * Name of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#type AuthBackend#type}
    */
    readonly type: string;
}
export interface AuthBackendTune {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#allowed_response_headers AuthBackend#allowed_response_headers}
    */
    readonly allowedResponseHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#audit_non_hmac_request_keys AuthBackend#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#audit_non_hmac_response_keys AuthBackend#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#default_lease_ttl AuthBackend#default_lease_ttl}
    */
    readonly defaultLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#listing_visibility AuthBackend#listing_visibility}
    */
    readonly listingVisibility?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#max_lease_ttl AuthBackend#max_lease_ttl}
    */
    readonly maxLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#passthrough_request_headers AuthBackend#passthrough_request_headers}
    */
    readonly passthroughRequestHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/auth_backend#token_type AuthBackend#token_type}
    */
    readonly tokenType?: string;
}
export declare function authBackendTuneToTerraform(struct?: AuthBackendTune | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/auth_backend vault_auth_backend}
*/
export declare class AuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/auth_backend vault_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: AuthBackendConfig);
    get accessor(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _tune?;
    get tune(): AuthBackendTune[] | cdktf.IResolvable;
    set tune(value: AuthBackendTune[] | cdktf.IResolvable);
    resetTune(): void;
    get tuneInput(): cdktf.IResolvable | AuthBackendTune[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=auth-backend.d.ts.map