import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuditConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-friendly description of the audit device.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit#description Audit#description}
    */
    readonly description?: string;
    /**
    * Specifies if the audit device is a local only. Local audit devices are not replicated nor (if a secondary) removed by replication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit#local Audit#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Configuration options to pass to the audit device itself.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit#options Audit#options}
    */
    readonly options: {
        [key: string]: string;
    };
    /**
    * Path in which to enable the audit device.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit#path Audit#path}
    */
    readonly path?: string;
    /**
    * Type of the audit device, such as 'file'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/audit#type Audit#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/audit vault_audit}
*/
export declare class Audit extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_audit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/audit vault_audit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuditConfig
    */
    constructor(scope: Construct, id: string, config: AuditConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=audit.d.ts.map