import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApproleAuthBackendLoginConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_login#backend ApproleAuthBackendLogin#backend}
    */
    readonly backend?: string;
    /**
    * The RoleID to log in with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_login#role_id ApproleAuthBackendLogin#role_id}
    */
    readonly roleId: string;
    /**
    * The SecretID to log in with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_login#secret_id ApproleAuthBackendLogin#secret_id}
    */
    readonly secretId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_login vault_approle_auth_backend_login}
*/
export declare class ApproleAuthBackendLogin extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_approle_auth_backend_login";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_login vault_approle_auth_backend_login} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApproleAuthBackendLoginConfig
    */
    constructor(scope: Construct, id: string, config: ApproleAuthBackendLoginConfig);
    get accessor(): string;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get clientToken(): string;
    get id(): string;
    get leaseDuration(): number;
    get leaseStarted(): string;
    metadata(key: string): string | cdktf.IResolvable;
    get policies(): string[];
    get renewable(): cdktf.IResolvable;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    resetSecretId(): void;
    get secretIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=approle-auth-backend-login.d.ts.map