"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdSecretBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend}
*/
class AdSecretBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdSecretBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_ad_secret_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._anonymousGroupSearch = config.anonymousGroupSearch;
        this._backend = config.backend;
        this._binddn = config.binddn;
        this._bindpass = config.bindpass;
        this._caseSensitiveNames = config.caseSensitiveNames;
        this._certificate = config.certificate;
        this._clientTlsCert = config.clientTlsCert;
        this._clientTlsKey = config.clientTlsKey;
        this._defaultLeaseTtlSeconds = config.defaultLeaseTtlSeconds;
        this._denyNullBind = config.denyNullBind;
        this._description = config.description;
        this._discoverdn = config.discoverdn;
        this._formatter = config.formatter;
        this._groupattr = config.groupattr;
        this._groupdn = config.groupdn;
        this._groupfilter = config.groupfilter;
        this._insecureTls = config.insecureTls;
        this._lastRotationTolerance = config.lastRotationTolerance;
        this._length = config.length;
        this._local = config.local;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._maxTtl = config.maxTtl;
        this._passwordPolicy = config.passwordPolicy;
        this._requestTimeout = config.requestTimeout;
        this._starttls = config.starttls;
        this._tlsMaxVersion = config.tlsMaxVersion;
        this._tlsMinVersion = config.tlsMinVersion;
        this._ttl = config.ttl;
        this._upndomain = config.upndomain;
        this._url = config.url;
        this._usePre111GroupCnBehavior = config.usePre111GroupCnBehavior;
        this._useTokenGroups = config.useTokenGroups;
        this._userattr = config.userattr;
        this._userdn = config.userdn;
    }
    get anonymousGroupSearch() {
        return this.getBooleanAttribute('anonymous_group_search');
    }
    set anonymousGroupSearch(value) {
        this._anonymousGroupSearch = value;
    }
    resetAnonymousGroupSearch() {
        this._anonymousGroupSearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get anonymousGroupSearchInput() {
        return this._anonymousGroupSearch;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get binddn() {
        return this.getStringAttribute('binddn');
    }
    set binddn(value) {
        this._binddn = value;
    }
    // Temporarily expose input value. Use with caution.
    get binddnInput() {
        return this._binddn;
    }
    get bindpass() {
        return this.getStringAttribute('bindpass');
    }
    set bindpass(value) {
        this._bindpass = value;
    }
    // Temporarily expose input value. Use with caution.
    get bindpassInput() {
        return this._bindpass;
    }
    get caseSensitiveNames() {
        return this.getBooleanAttribute('case_sensitive_names');
    }
    set caseSensitiveNames(value) {
        this._caseSensitiveNames = value;
    }
    resetCaseSensitiveNames() {
        this._caseSensitiveNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caseSensitiveNamesInput() {
        return this._caseSensitiveNames;
    }
    get certificate() {
        return this.getStringAttribute('certificate');
    }
    set certificate(value) {
        this._certificate = value;
    }
    resetCertificate() {
        this._certificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateInput() {
        return this._certificate;
    }
    get clientTlsCert() {
        return this.getStringAttribute('client_tls_cert');
    }
    set clientTlsCert(value) {
        this._clientTlsCert = value;
    }
    resetClientTlsCert() {
        this._clientTlsCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsCertInput() {
        return this._clientTlsCert;
    }
    get clientTlsKey() {
        return this.getStringAttribute('client_tls_key');
    }
    set clientTlsKey(value) {
        this._clientTlsKey = value;
    }
    resetClientTlsKey() {
        this._clientTlsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsKeyInput() {
        return this._clientTlsKey;
    }
    get defaultLeaseTtlSeconds() {
        return this.getNumberAttribute('default_lease_ttl_seconds');
    }
    set defaultLeaseTtlSeconds(value) {
        this._defaultLeaseTtlSeconds = value;
    }
    resetDefaultLeaseTtlSeconds() {
        this._defaultLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlSecondsInput() {
        return this._defaultLeaseTtlSeconds;
    }
    get denyNullBind() {
        return this.getBooleanAttribute('deny_null_bind');
    }
    set denyNullBind(value) {
        this._denyNullBind = value;
    }
    resetDenyNullBind() {
        this._denyNullBind = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyNullBindInput() {
        return this._denyNullBind;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get discoverdn() {
        return this.getBooleanAttribute('discoverdn');
    }
    set discoverdn(value) {
        this._discoverdn = value;
    }
    resetDiscoverdn() {
        this._discoverdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discoverdnInput() {
        return this._discoverdn;
    }
    get formatter() {
        return this.getStringAttribute('formatter');
    }
    set formatter(value) {
        this._formatter = value;
    }
    resetFormatter() {
        this._formatter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get formatterInput() {
        return this._formatter;
    }
    get groupattr() {
        return this.getStringAttribute('groupattr');
    }
    set groupattr(value) {
        this._groupattr = value;
    }
    resetGroupattr() {
        this._groupattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupattrInput() {
        return this._groupattr;
    }
    get groupdn() {
        return this.getStringAttribute('groupdn');
    }
    set groupdn(value) {
        this._groupdn = value;
    }
    resetGroupdn() {
        this._groupdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupdnInput() {
        return this._groupdn;
    }
    get groupfilter() {
        return this.getStringAttribute('groupfilter');
    }
    set groupfilter(value) {
        this._groupfilter = value;
    }
    resetGroupfilter() {
        this._groupfilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupfilterInput() {
        return this._groupfilter;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get insecureTls() {
        return this.getBooleanAttribute('insecure_tls');
    }
    set insecureTls(value) {
        this._insecureTls = value;
    }
    resetInsecureTls() {
        this._insecureTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureTlsInput() {
        return this._insecureTls;
    }
    get lastRotationTolerance() {
        return this.getNumberAttribute('last_rotation_tolerance');
    }
    set lastRotationTolerance(value) {
        this._lastRotationTolerance = value;
    }
    resetLastRotationTolerance() {
        this._lastRotationTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastRotationToleranceInput() {
        return this._lastRotationTolerance;
    }
    get length() {
        return this.getNumberAttribute('length');
    }
    set length(value) {
        this._length = value;
    }
    resetLength() {
        this._length = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lengthInput() {
        return this._length;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get maxLeaseTtlSeconds() {
        return this.getNumberAttribute('max_lease_ttl_seconds');
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get maxTtl() {
        return this.getNumberAttribute('max_ttl');
    }
    set maxTtl(value) {
        this._maxTtl = value;
    }
    resetMaxTtl() {
        this._maxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTtlInput() {
        return this._maxTtl;
    }
    get passwordPolicy() {
        return this.getStringAttribute('password_policy');
    }
    set passwordPolicy(value) {
        this._passwordPolicy = value;
    }
    resetPasswordPolicy() {
        this._passwordPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordPolicyInput() {
        return this._passwordPolicy;
    }
    get requestTimeout() {
        return this.getNumberAttribute('request_timeout');
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get starttls() {
        return this.getBooleanAttribute('starttls');
    }
    set starttls(value) {
        this._starttls = value;
    }
    resetStarttls() {
        this._starttls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get starttlsInput() {
        return this._starttls;
    }
    get tlsMaxVersion() {
        return this.getStringAttribute('tls_max_version');
    }
    set tlsMaxVersion(value) {
        this._tlsMaxVersion = value;
    }
    resetTlsMaxVersion() {
        this._tlsMaxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMaxVersionInput() {
        return this._tlsMaxVersion;
    }
    get tlsMinVersion() {
        return this.getStringAttribute('tls_min_version');
    }
    set tlsMinVersion(value) {
        this._tlsMinVersion = value;
    }
    resetTlsMinVersion() {
        this._tlsMinVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMinVersionInput() {
        return this._tlsMinVersion;
    }
    get ttl() {
        return this.getNumberAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    resetTtl() {
        this._ttl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
    get upndomain() {
        return this.getStringAttribute('upndomain');
    }
    set upndomain(value) {
        this._upndomain = value;
    }
    resetUpndomain() {
        this._upndomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upndomainInput() {
        return this._upndomain;
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    resetUrl() {
        this._url = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
    get usePre111GroupCnBehavior() {
        return this.getBooleanAttribute('use_pre111_group_cn_behavior');
    }
    set usePre111GroupCnBehavior(value) {
        this._usePre111GroupCnBehavior = value;
    }
    resetUsePre111GroupCnBehavior() {
        this._usePre111GroupCnBehavior = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usePre111GroupCnBehaviorInput() {
        return this._usePre111GroupCnBehavior;
    }
    get useTokenGroups() {
        return this.getBooleanAttribute('use_token_groups');
    }
    set useTokenGroups(value) {
        this._useTokenGroups = value;
    }
    resetUseTokenGroups() {
        this._useTokenGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useTokenGroupsInput() {
        return this._useTokenGroups;
    }
    get userattr() {
        return this.getStringAttribute('userattr');
    }
    set userattr(value) {
        this._userattr = value;
    }
    resetUserattr() {
        this._userattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userattrInput() {
        return this._userattr;
    }
    get userdn() {
        return this.getStringAttribute('userdn');
    }
    set userdn(value) {
        this._userdn = value;
    }
    resetUserdn() {
        this._userdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userdnInput() {
        return this._userdn;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            anonymous_group_search: cdktf.booleanToTerraform(this._anonymousGroupSearch),
            backend: cdktf.stringToTerraform(this._backend),
            binddn: cdktf.stringToTerraform(this._binddn),
            bindpass: cdktf.stringToTerraform(this._bindpass),
            case_sensitive_names: cdktf.booleanToTerraform(this._caseSensitiveNames),
            certificate: cdktf.stringToTerraform(this._certificate),
            client_tls_cert: cdktf.stringToTerraform(this._clientTlsCert),
            client_tls_key: cdktf.stringToTerraform(this._clientTlsKey),
            default_lease_ttl_seconds: cdktf.numberToTerraform(this._defaultLeaseTtlSeconds),
            deny_null_bind: cdktf.booleanToTerraform(this._denyNullBind),
            description: cdktf.stringToTerraform(this._description),
            discoverdn: cdktf.booleanToTerraform(this._discoverdn),
            formatter: cdktf.stringToTerraform(this._formatter),
            groupattr: cdktf.stringToTerraform(this._groupattr),
            groupdn: cdktf.stringToTerraform(this._groupdn),
            groupfilter: cdktf.stringToTerraform(this._groupfilter),
            insecure_tls: cdktf.booleanToTerraform(this._insecureTls),
            last_rotation_tolerance: cdktf.numberToTerraform(this._lastRotationTolerance),
            length: cdktf.numberToTerraform(this._length),
            local: cdktf.booleanToTerraform(this._local),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            max_ttl: cdktf.numberToTerraform(this._maxTtl),
            password_policy: cdktf.stringToTerraform(this._passwordPolicy),
            request_timeout: cdktf.numberToTerraform(this._requestTimeout),
            starttls: cdktf.booleanToTerraform(this._starttls),
            tls_max_version: cdktf.stringToTerraform(this._tlsMaxVersion),
            tls_min_version: cdktf.stringToTerraform(this._tlsMinVersion),
            ttl: cdktf.numberToTerraform(this._ttl),
            upndomain: cdktf.stringToTerraform(this._upndomain),
            url: cdktf.stringToTerraform(this._url),
            use_pre111_group_cn_behavior: cdktf.booleanToTerraform(this._usePre111GroupCnBehavior),
            use_token_groups: cdktf.booleanToTerraform(this._useTokenGroups),
            userattr: cdktf.stringToTerraform(this._userattr),
            userdn: cdktf.stringToTerraform(this._userdn),
        };
    }
}
exports.AdSecretBackend = AdSecretBackend;
_a = JSII_RTTI_SYMBOL_1;
AdSecretBackend[_a] = { fqn: "hashicorp_vault.AdSecretBackend", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
AdSecretBackend.tfResourceType = "vault_ad_secret_backend";
//# sourceMappingURL=data:application/json;base64,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