# Generated by Django 2.2.4 on 2019-08-23 16:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='DiscordChannel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('external_id', models.BigIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='DiscordClient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_endpoint', models.URLField(default='https://discordapp.com/api/v6')),
                ('base_uri', models.URLField(default='https://discordapp.com/api/oauth2/authorize')),
                ('token_uri', models.URLField(default='https://discordapp.com/api/oauth2/token')),
                ('token_revoke_uri', models.URLField(default='https://discordapp.com/api/oauth2/token/revoke')),
                ('callback_url', models.URLField()),
                ('server_id', models.IntegerField()),
                ('client_id', models.IntegerField()),
                ('secret', models.CharField(max_length=255)),
                ('bot_token', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='DiscordGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('external_id', models.BigIntegerField(blank=True, null=True)),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='discord_group', to='auth.Group')),
            ],
        ),
        migrations.CreateModel(
            name='DiscordToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=255)),
                ('nickname', models.CharField(max_length=255)),
                ('access_token', models.CharField(max_length=255)),
                ('refresh_token', models.CharField(max_length=255)),
                ('external_id', models.BigIntegerField()),
                ('groups', models.ManyToManyField(to='django_discord_connector.DiscordGroup')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='discord_token', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
