// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../../utils/classNames';
import { GraphSidebarTab } from '../../../types';
/*
    The tabs at the bottom of the graph sidebar that let you switch between
    setup, style, and export
*/
function GraphSidebarTabs(props) {
    const changeTab = (tab) => {
        props.setSelectedGraphSidebarTab(tab);
        // Send a log message saying that this tab has been clicked,
        // and keeping the tab at the highest level
        void props.mitoAPI.log('clicked_graph_' + tab + '_tab');
    };
    return (React.createElement("div", { className: 'graph-sidebar-tab-container' },
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === GraphSidebarTab.Setup ? 'selected' : 'unselected'), onClick: () => changeTab(GraphSidebarTab.Setup) },
            React.createElement("p", null, "Setup")),
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === GraphSidebarTab.Style ? 'selected' : 'unselected'), onClick: () => changeTab(GraphSidebarTab.Style) },
            React.createElement("p", null, "Style")),
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === GraphSidebarTab.Export ? 'selected' : 'unselected'), onClick: () => changeTab(GraphSidebarTab.Export) },
            React.createElement("p", null, "Export"))));
}
export default GraphSidebarTabs;
//# sourceMappingURL=GraphSidebarTabs.js.map