// Copyright (c) Saga Inc.
import React from 'react';
import TextButton from '../../elements/TextButton';
import { useCopyToClipboard } from '../../../hooks/useCopyToClipboard';
/*
    The export tab that lets the user copy the graph code or download as a png
*/
function GraphExportTab(props) {
    var _a;
    const [_copyGraphCode, graphCodeCopied] = useCopyToClipboard((_a = props.graphOutput) === null || _a === void 0 ? void 0 : _a.graphGeneratedCode);
    const copyGraphCode = () => {
        _copyGraphCode();
        // Log that the user copied the graph code
        void props.mitoAPI.log('copy_graph_code', {
            'graph_type': props.graphParams.graphCreation.graph_type
        });
    };
    return (React.createElement("div", { className: 'graph-sidebar-toolbar-content' },
        React.createElement("div", null,
            React.createElement(TextButton, { variant: 'dark', onClick: copyGraphCode, disabled: props.loading || props.graphOutput === undefined }, !graphCodeCopied
                ? "Copy Graph Code"
                : "Copied to Clipboard!")),
        React.createElement("div", null,
            React.createElement(TextButton, { variant: 'dark', onClick: () => {
                    var _a;
                    // Find the Plotly Download plot as png button, and then click it. 
                    const downloadLink = (_a = props.mitoContainerRef.current) === null || _a === void 0 ? void 0 : _a.querySelector('[data-title="Download plot as a png"]');
                    downloadLink === null || downloadLink === void 0 ? void 0 : downloadLink.click();
                }, disabled: props.loading || props.graphOutput === undefined }, "Download as PNG"))));
}
export default GraphExportTab;
//# sourceMappingURL=GraphExportTab.js.map