// Copyright (c) Mito
import React from 'react';
import { BOOLEAN_SELECT_OPTIONS, CONDITIONS_WITH_NO_INPUT, DATETIME_SELECT_OPTIONS, NUMBER_SELECT_OPTIONS, STRING_SELECT_OPTIONS } from './filterConditions';
import Row from '../../../../spacing/Row';
import Col from '../../../../spacing/Col';
import Select from '../../../../elements/Select';
import XIcon from '../../../../icons/XIcon';
import DropdownItem from '../../../../elements/DropdownItem';
import { isBoolDtype, isDatetimeDtype, isNumberDtype } from '../../../../../utils/dtypes';
export function Filter(props) {
    // We hide the input if it is not necessary
    const inputStyle = CONDITIONS_WITH_NO_INPUT.includes(props.filter.condition) ? { 'visibility': 'hidden' } : { 'visibility': 'visible' };
    const getFilterOptions = () => {
        if (isNumberDtype(props.columnDtype)) {
            return Object.entries(NUMBER_SELECT_OPTIONS).map(([filterCondition, displayFilterCondition]) => {
                return (React.createElement(DropdownItem, { key: filterCondition, id: filterCondition, title: displayFilterCondition }));
            });
        }
        else if (isBoolDtype(props.columnDtype)) {
            return Object.entries(BOOLEAN_SELECT_OPTIONS).map(([filterCondition, displayFilterCondition]) => {
                return (React.createElement(DropdownItem, { key: filterCondition, id: filterCondition, title: displayFilterCondition }));
            });
        }
        else if (isDatetimeDtype(props.columnDtype)) {
            return Object.entries(DATETIME_SELECT_OPTIONS).map(([filterCondition, displayFilterCondition]) => {
                return (React.createElement(DropdownItem, { key: filterCondition, id: filterCondition, title: displayFilterCondition }));
            });
        }
        return Object.entries(STRING_SELECT_OPTIONS).map(([filterCondition, displayFilterCondition]) => {
            return (React.createElement(DropdownItem, { key: filterCondition, id: filterCondition, title: displayFilterCondition }));
        });
    };
    const filterConditionOptions = getFilterOptions();
    return (React.createElement(Row, { justify: 'space-between', align: 'center' },
        React.createElement(Col, { span: !props.inGroup ? 4 : 5 },
            props.first &&
                React.createElement("p", { className: 'text-body-1' }, "Where"),
            !props.first &&
                React.createElement(Select, { value: props.operator, onChange: (newOperator) => props.setOperator(newOperator), dropdownWidth: 'small' },
                    React.createElement(DropdownItem, { title: 'And' }),
                    React.createElement(DropdownItem, { title: 'Or' }))),
        React.createElement(Col, { span: 7 },
            React.createElement(Select, { value: props.filter.condition, onChange: (newFilterCondition) => {
                    props.setFilter({
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        condition: newFilterCondition,
                        value: props.filter.value
                    });
                }, width: 'block', dropdownWidth: 'medium' }, filterConditionOptions)),
        React.createElement(Col, { span: 9 },
            React.createElement("input", { className: 'mito-input element-width-block', style: inputStyle, type: isDatetimeDtype(props.columnDtype) ? 'date' : 'text', value: props.filter.value, onChange: e => {
                    props.setFilter({
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        condition: props.filter.condition,
                        value: e.target.value
                    });
                } })),
        React.createElement(Col, null,
            React.createElement(XIcon, { onClick: props.deleteFilter }))));
}
//# sourceMappingURL=Filter.js.map