# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.30.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from intrinio_sdk.api_client import ApiClient


class TechnicalApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_security_price_technicals_adi(self, identifier, **kwargs):  # noqa: E501
        """Accumulation/Distribution Index  # noqa: E501

        The Accumulation / Distribution Indicator is a volume-based technical indicator which uses the relationship between the stock`s price and volume flow to determine the underlying trend of a stock, up, down, or sideways trend of a stock.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAccumulationDistributionIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Accumulation/Distribution Index  # noqa: E501

        The Accumulation / Distribution Indicator is a volume-based technical indicator which uses the relationship between the stock`s price and volume flow to determine the underlying trend of a stock, up, down, or sideways trend of a stock.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAccumulationDistributionIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAccumulationDistributionIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_adtv(self, identifier, **kwargs):  # noqa: E501
        """Average Daily Trading Volume  # noqa: E501

        Average Daily Trading Volume is the average number of shares traded over a given period, usually between 20 to 30 trading days.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adtv(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Daily Trading Volume
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDailyTradingVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adtv_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adtv_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adtv_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average Daily Trading Volume  # noqa: E501

        Average Daily Trading Volume is the average number of shares traded over a given period, usually between 20 to 30 trading days.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adtv_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Daily Trading Volume
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDailyTradingVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adtv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adtv`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_adtv`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adtv`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adtv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageDailyTradingVolume',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_adx(self, identifier, **kwargs):  # noqa: E501
        """Average Directional Index  # noqa: E501

        The Average Directional Index indicator is often used to identify decreasing or increasing price momentum for an underlying security, it is composed of a total of three indicators, the current trendline (adx), a positive directional indicator (di_pos), and a negative directional indicator (di_neg).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adx(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Directional Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDirectionalIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adx_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adx_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adx_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average Directional Index  # noqa: E501

        The Average Directional Index indicator is often used to identify decreasing or increasing price momentum for an underlying security, it is composed of a total of three indicators, the current trendline (adx), a positive directional indicator (di_pos), and a negative directional indicator (di_neg).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adx_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Directional Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDirectionalIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adx`")  # noqa: E501

        if 'period' in params and params['period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_adx`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adx`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adx', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageDirectionalIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_ao(self, identifier, **kwargs):  # noqa: E501
        """Awesome Oscillator  # noqa: E501

        The Awesome Oscillator (ao) is a momentum indicator and is calculated by taking the difference between the latest 5 period simple moving average and the 34 period simple moving average. Rather than using the closing price like other indicators, the Awesome Oscillator uses the latest period`s midpoint value (period_high - period_low / 2). The Awesome Oscillator is useful in identifying and trading, zero-line crossovers, twin-peaks trading, and bullish/bearish saucers - Awesome Oscillator is often aggregated with additional technical indicators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ao(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate short period Simple Moving Average of the Awesome Oscillator
        :param int long_period: The number of observations, per period, to calculate long period Simple Moving Average of the Awesome Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAwesomeOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_ao_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_ao_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_ao_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Awesome Oscillator  # noqa: E501

        The Awesome Oscillator (ao) is a momentum indicator and is calculated by taking the difference between the latest 5 period simple moving average and the 34 period simple moving average. Rather than using the closing price like other indicators, the Awesome Oscillator uses the latest period`s midpoint value (period_high - period_low / 2). The Awesome Oscillator is useful in identifying and trading, zero-line crossovers, twin-peaks trading, and bullish/bearish saucers - Awesome Oscillator is often aggregated with additional technical indicators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ao_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate short period Simple Moving Average of the Awesome Oscillator
        :param int long_period: The number of observations, per period, to calculate long period Simple Moving Average of the Awesome Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAwesomeOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'short_period', 'long_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_ao" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_ao`")  # noqa: E501

        if 'long_period' in params and params['long_period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `long_period` when calling `get_security_price_technicals_ao`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_ao`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'short_period' in params:
            query_params.append(('short_period', params['short_period']))  # noqa: E501
        if 'long_period' in params:
            query_params.append(('long_period', params['long_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/ao', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAwesomeOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_atr(self, identifier, **kwargs):  # noqa: E501
        """Average True Range  # noqa: E501

        The Average True Range (ATR) is a non-directional market volatility indicator often used to generate stop-out or entry indications. An increasing or expanding ATR typically indicates higher volatility, and a decreasing ATR indicates sideways price action and lower volatility.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_atr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average True Range
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageTrueRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_atr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_atr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_atr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average True Range  # noqa: E501

        The Average True Range (ATR) is a non-directional market volatility indicator often used to generate stop-out or entry indications. An increasing or expanding ATR typically indicates higher volatility, and a decreasing ATR indicates sideways price action and lower volatility.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_atr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average True Range
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageTrueRange
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_atr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_atr`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_atr`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_atr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/atr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageTrueRange',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_bb(self, identifier, **kwargs):  # noqa: E501
        """Bollinger Bands  # noqa: E501

        Bollinger Bands can be a useful technical analysis tool for generating oversold or overbought indicators. Bollinger Bands are composed of three lines, a simple moving average (middle band) and an upper and lower band – the upper and lower bands are typically 2 standard deviations +/- from a 20-day simple moving average, but can be modified. Traders typically consider an underlying security to be overbought as the underlying`s price moves towards the upper band and oversold as the underlying price moves towards the lower band.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_bb(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Bollinger Bands
        :param float standard_deviations: The number of standard deviations to calculate the upper and lower bands of the Bollinger Bands
        :param str price_key: The Stock Price field to use when calculating Bollinger Bands
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityBollingerBands
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_bb_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_bb_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_bb_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Bollinger Bands  # noqa: E501

        Bollinger Bands can be a useful technical analysis tool for generating oversold or overbought indicators. Bollinger Bands are composed of three lines, a simple moving average (middle band) and an upper and lower band – the upper and lower bands are typically 2 standard deviations +/- from a 20-day simple moving average, but can be modified. Traders typically consider an underlying security to be overbought as the underlying`s price moves towards the upper band and oversold as the underlying price moves towards the lower band.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_bb_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Bollinger Bands
        :param float standard_deviations: The number of standard deviations to calculate the upper and lower bands of the Bollinger Bands
        :param str price_key: The Stock Price field to use when calculating Bollinger Bands
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityBollingerBands
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'standard_deviations', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_bb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_bb`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_bb`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_bb`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'standard_deviations' in params:
            query_params.append(('standard_deviations', params['standard_deviations']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/bb', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityBollingerBands',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_cci(self, identifier, **kwargs):  # noqa: E501
        """Commodity Channel Index  # noqa: E501

        The Commodity Channel Index (CCI) is a technical indicator used to generate buy and sell signals by indicating periods of strength and weakness in the market. CCI signals that fall below -100 are often perceived as weakness in the underlying price movement and CCI signals that rise above 100 indicate strength behind the underlying price movement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cci(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Commodity Channel Index
        :param float constant: The number of observations, per period, to calculate Commodity Channel Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityCommodityChannelIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_cci_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_cci_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_cci_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Commodity Channel Index  # noqa: E501

        The Commodity Channel Index (CCI) is a technical indicator used to generate buy and sell signals by indicating periods of strength and weakness in the market. CCI signals that fall below -100 are often perceived as weakness in the underlying price movement and CCI signals that rise above 100 indicate strength behind the underlying price movement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cci_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Commodity Channel Index
        :param float constant: The number of observations, per period, to calculate Commodity Channel Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityCommodityChannelIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'constant', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_cci" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_cci`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_cci`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_cci`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'constant' in params:
            query_params.append(('constant', params['constant']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/cci', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityCommodityChannelIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_cmf(self, identifier, **kwargs):  # noqa: E501
        """Chaikin Money Flow  # noqa: E501

        The Chaikin Money Flow (CMF) utilizes exponential moving averages as an indicator to monitor the flow of money and momentum. The CMF indicator oscillates around a midrange 0-line and ranges between 100 and -100.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cmf(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Chaikin Money Flow
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityChaikinMoneyFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_cmf_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_cmf_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_cmf_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Chaikin Money Flow  # noqa: E501

        The Chaikin Money Flow (CMF) utilizes exponential moving averages as an indicator to monitor the flow of money and momentum. The CMF indicator oscillates around a midrange 0-line and ranges between 100 and -100.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cmf_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Chaikin Money Flow
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityChaikinMoneyFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_cmf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_cmf`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_cmf`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_cmf`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/cmf', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityChaikinMoneyFlow',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_dc(self, identifier, **kwargs):  # noqa: E501
        """Donchian Channel  # noqa: E501

        The Donchian Channel consists of an Upper Bound (upper_bound) and Lower Bound (lower_bound) that track the recent highs and lows and is often used to signal entry and exit points for a position. As the price of the underlying symbol increases the Upper Bound raises, if the price becomes range bound the Upper Bound will remain flat and if the price begins to decrease, the Upper Bound will fall (and vice-versa for the Lower Bound).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dc(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Donchian Channel
        :param str price_key: The Stock Price field to use when calculating Donchian Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDonchianChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_dc_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_dc_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_dc_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Donchian Channel  # noqa: E501

        The Donchian Channel consists of an Upper Bound (upper_bound) and Lower Bound (lower_bound) that track the recent highs and lows and is often used to signal entry and exit points for a position. As the price of the underlying symbol increases the Upper Bound raises, if the price becomes range bound the Upper Bound will remain flat and if the price begins to decrease, the Upper Bound will fall (and vice-versa for the Lower Bound).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dc_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Donchian Channel
        :param str price_key: The Stock Price field to use when calculating Donchian Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDonchianChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_dc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_dc`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_dc`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_dc`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/dc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityDonchianChannel',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_dpo(self, identifier, **kwargs):  # noqa: E501
        """Detrended Price Oscillator  # noqa: E501

        The Detrended Price Oscillator (DPO) signals the peaks and troughs of the underlying symbol’s price for a set period of time and is often used by traders to estimate future peaks and troughs using this as guidance to enter or exit a position.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dpo(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Detrended Price Oscillator
        :param str price_key: The Stock Price field to use when calculating Detrended Price Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDetrendedPriceOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_dpo_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_dpo_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_dpo_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Detrended Price Oscillator  # noqa: E501

        The Detrended Price Oscillator (DPO) signals the peaks and troughs of the underlying symbol’s price for a set period of time and is often used by traders to estimate future peaks and troughs using this as guidance to enter or exit a position.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dpo_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Detrended Price Oscillator
        :param str price_key: The Stock Price field to use when calculating Detrended Price Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDetrendedPriceOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_dpo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_dpo`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_dpo`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/dpo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityDetrendedPriceOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_eom(self, identifier, **kwargs):  # noqa: E501
        """Ease of Movement  # noqa: E501

        The Ease of Movement (EOM) is a volume based oscillator that fluctuates around a midrange 0-line into positive and negative values. Positive values indicate that the underlying symbol`s price is rising with relative ease and negative value indicates the underlying symbol`s price is failing with relative ease.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_eom(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Ease of Movement
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityEaseOfMovement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_eom_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_eom_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_eom_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ease of Movement  # noqa: E501

        The Ease of Movement (EOM) is a volume based oscillator that fluctuates around a midrange 0-line into positive and negative values. Positive values indicate that the underlying symbol`s price is rising with relative ease and negative value indicates the underlying symbol`s price is failing with relative ease.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_eom_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Ease of Movement
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityEaseOfMovement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_eom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_eom`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_eom`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_eom`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/eom', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityEaseOfMovement',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_fi(self, identifier, **kwargs):  # noqa: E501
        """Force Index  # noqa: E501

        The Force Index (FI) is an oscillator that takes into account the intensity of an underlying symbol`s price movement and its corresponding volume. It is used to confirm price breakouts and signal underlying trends.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_fi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityForceIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_fi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_fi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_fi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Force Index  # noqa: E501

        The Force Index (FI) is an oscillator that takes into account the intensity of an underlying symbol`s price movement and its corresponding volume. It is used to confirm price breakouts and signal underlying trends.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_fi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityForceIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_fi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_fi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_fi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/fi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityForceIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_ichimoku(self, identifier, **kwargs):  # noqa: E501
        """Ichimoku Kinko Hyo  # noqa: E501

        The Ichimoku Kinko Hyo was designed to be an all-in-one trading indicator that could help traders determine momentum, support, and resistance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ichimoku(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate Tenkan Sen (Conversion Line) of Ichimoku Kinko Hyo
        :param int medium_period: The number of observations, per period, to calculate Kijun Sen (Base Line), Senkou Span A (Leading Span A), and Chikou Span (Lagging Span) of Ichimoku Kinko Hyo
        :param int high_period: The number of observations, per period, to calculate Senkou Span B (Leading Span B) of Ichimoku Kinko Hyo
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIchimokuKinkoHyo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_ichimoku_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_ichimoku_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_ichimoku_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ichimoku Kinko Hyo  # noqa: E501

        The Ichimoku Kinko Hyo was designed to be an all-in-one trading indicator that could help traders determine momentum, support, and resistance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ichimoku_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate Tenkan Sen (Conversion Line) of Ichimoku Kinko Hyo
        :param int medium_period: The number of observations, per period, to calculate Kijun Sen (Base Line), Senkou Span A (Leading Span A), and Chikou Span (Lagging Span) of Ichimoku Kinko Hyo
        :param int high_period: The number of observations, per period, to calculate Senkou Span B (Leading Span B) of Ichimoku Kinko Hyo
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIchimokuKinkoHyo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'low_period', 'medium_period', 'high_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_ichimoku" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_ichimoku`")  # noqa: E501

        if 'medium_period' in params and params['medium_period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `medium_period` when calling `get_security_price_technicals_ichimoku`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'high_period' in params and params['high_period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `high_period` when calling `get_security_price_technicals_ichimoku`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_ichimoku`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'low_period' in params:
            query_params.append(('low_period', params['low_period']))  # noqa: E501
        if 'medium_period' in params:
            query_params.append(('medium_period', params['medium_period']))  # noqa: E501
        if 'high_period' in params:
            query_params.append(('high_period', params['high_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/ichimoku', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityIchimokuKinkoHyo',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_kc(self, identifier, **kwargs):  # noqa: E501
        """Keltner Channel  # noqa: E501

        The Keltner Channel is a volatility based signal, with upper, middle, and lower bands. It is often used at market open, when the largest moves tend to occur. In general, traders tend to buy if the price breaks up above the upper band or sell short if the price drops below the lower band.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kc(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Kelter Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKeltnerChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_kc_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_kc_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_kc_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Keltner Channel  # noqa: E501

        The Keltner Channel is a volatility based signal, with upper, middle, and lower bands. It is often used at market open, when the largest moves tend to occur. In general, traders tend to buy if the price breaks up above the upper band or sell short if the price drops below the lower band.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kc_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Kelter Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKeltnerChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_kc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_kc`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_kc`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_kc`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/kc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityKeltnerChannel',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_kst(self, identifier, **kwargs):  # noqa: E501
        """Know Sure Thing  # noqa: E501

        The Know Sure Thing indicator (KST) is a momentum based oscillator that is calculated by measuring the momentum of four separate price cycles. KST fluctuates above and below a zero line and is used to identify overbought and oversold conditions, and is often used with additional indicators to boost signal strength.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kst(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int roc1: The number of observations, per period, to calculate the rate-of-change for RCMA1
        :param int roc2: The number of observations, per period, to calculate the rate-of-change for RCMA2
        :param int roc3: The number of observations, per period, to calculate the rate-of-change for RCMA3
        :param int roc4: The number of observations, per period, to calculate the rate-of-change for RCMA4
        :param int sma1: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA1
        :param int sma2: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA2
        :param int sma3: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA3
        :param int sma4: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA4
        :param str price_key: The Stock Price field to use when calculating Know Sure Thing
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKnowSureThing
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_kst_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_kst_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_kst_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Know Sure Thing  # noqa: E501

        The Know Sure Thing indicator (KST) is a momentum based oscillator that is calculated by measuring the momentum of four separate price cycles. KST fluctuates above and below a zero line and is used to identify overbought and oversold conditions, and is often used with additional indicators to boost signal strength.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kst_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int roc1: The number of observations, per period, to calculate the rate-of-change for RCMA1
        :param int roc2: The number of observations, per period, to calculate the rate-of-change for RCMA2
        :param int roc3: The number of observations, per period, to calculate the rate-of-change for RCMA3
        :param int roc4: The number of observations, per period, to calculate the rate-of-change for RCMA4
        :param int sma1: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA1
        :param int sma2: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA2
        :param int sma3: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA3
        :param int sma4: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA4
        :param str price_key: The Stock Price field to use when calculating Know Sure Thing
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKnowSureThing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'roc1', 'roc2', 'roc3', 'roc4', 'sma1', 'sma2', 'sma3', 'sma4', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_kst" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_kst`")  # noqa: E501

        if 'roc4' in params and params['roc4'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `roc4` when calling `get_security_price_technicals_kst`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'sma4' in params and params['sma4'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `sma4` when calling `get_security_price_technicals_kst`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_kst`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'roc1' in params:
            query_params.append(('roc1', params['roc1']))  # noqa: E501
        if 'roc2' in params:
            query_params.append(('roc2', params['roc2']))  # noqa: E501
        if 'roc3' in params:
            query_params.append(('roc3', params['roc3']))  # noqa: E501
        if 'roc4' in params:
            query_params.append(('roc4', params['roc4']))  # noqa: E501
        if 'sma1' in params:
            query_params.append(('sma1', params['sma1']))  # noqa: E501
        if 'sma2' in params:
            query_params.append(('sma2', params['sma2']))  # noqa: E501
        if 'sma3' in params:
            query_params.append(('sma3', params['sma3']))  # noqa: E501
        if 'sma4' in params:
            query_params.append(('sma4', params['sma4']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/kst', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityKnowSureThing',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_macd(self, identifier, **kwargs):  # noqa: E501
        """Moving Average Convergence Divergence  # noqa: E501

        Moving average convergence divergence (MACD) is a trend-following momentum oscillator that consists of three indicators: (1) a 12 period short-term exponential moving average (EMA) a 26 period long-term EMA and a 9 period EMA signal line. Traders using MACD often look for signal line crossovers, centerline crossovers, and EMA divergences to indicate the momentum and underlying trend of a security`s price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_macd(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int fast_period: The number of observations, per period, to calculate the fast moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int slow_period: The number of observations, per period, to calculate the slow moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int signal_period: The number of observations, per period, to calculate the signal line for Moving Average Convergence Divergence
        :param str price_key: The Stock Price field to use when calculating Moving Average Convergence Divergence
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMovingAverageConvergenceDivergence
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_macd_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_macd_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_macd_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Moving Average Convergence Divergence  # noqa: E501

        Moving average convergence divergence (MACD) is a trend-following momentum oscillator that consists of three indicators: (1) a 12 period short-term exponential moving average (EMA) a 26 period long-term EMA and a 9 period EMA signal line. Traders using MACD often look for signal line crossovers, centerline crossovers, and EMA divergences to indicate the momentum and underlying trend of a security`s price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_macd_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int fast_period: The number of observations, per period, to calculate the fast moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int slow_period: The number of observations, per period, to calculate the slow moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int signal_period: The number of observations, per period, to calculate the signal line for Moving Average Convergence Divergence
        :param str price_key: The Stock Price field to use when calculating Moving Average Convergence Divergence
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMovingAverageConvergenceDivergence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'fast_period', 'slow_period', 'signal_period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_macd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_macd`")  # noqa: E501

        if 'slow_period' in params and params['slow_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `slow_period` when calling `get_security_price_technicals_macd`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'signal_period' in params and params['signal_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `signal_period` when calling `get_security_price_technicals_macd`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_macd`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'fast_period' in params:
            query_params.append(('fast_period', params['fast_period']))  # noqa: E501
        if 'slow_period' in params:
            query_params.append(('slow_period', params['slow_period']))  # noqa: E501
        if 'signal_period' in params:
            query_params.append(('signal_period', params['signal_period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/macd', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMovingAverageConvergenceDivergence',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_mfi(self, identifier, **kwargs):  # noqa: E501
        """Money Flow Index  # noqa: E501

        The Money Flow Index (MFI) is a technical oscillator that incorporates both price and volume, moving between 0 and 100. Traders often consider a MFI above 80 as overbought conditions and below 20 as oversold conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mfi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Money Flow Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMoneyFlowIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_mfi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_mfi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_mfi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Money Flow Index  # noqa: E501

        The Money Flow Index (MFI) is a technical oscillator that incorporates both price and volume, moving between 0 and 100. Traders often consider a MFI above 80 as overbought conditions and below 20 as oversold conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mfi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Money Flow Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMoneyFlowIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_mfi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_mfi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_mfi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_mfi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/mfi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMoneyFlowIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_mi(self, identifier, **kwargs):  # noqa: E501
        """Mass Index  # noqa: E501

        The mass index (MI) is a technical indicator used by traders to predict trend reversals. A trend reversal signal is said to occur when the 25-day MI reaches 27.0 and then falls below 26.0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int ema_period: The number of observations, per period, to calculate the single Exponential Moving Average and the Double Exponential Moving Average for Mass Index
        :param int sum_period: The number of observations, per period, to calculate the sum of the Exponetinal Moving Average Ratios for Mass Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMassIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_mi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_mi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_mi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Mass Index  # noqa: E501

        The mass index (MI) is a technical indicator used by traders to predict trend reversals. A trend reversal signal is said to occur when the 25-day MI reaches 27.0 and then falls below 26.0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int ema_period: The number of observations, per period, to calculate the single Exponential Moving Average and the Double Exponential Moving Average for Mass Index
        :param int sum_period: The number of observations, per period, to calculate the sum of the Exponetinal Moving Average Ratios for Mass Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMassIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'ema_period', 'sum_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_mi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_mi`")  # noqa: E501

        if 'ema_period' in params and params['ema_period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `ema_period` when calling `get_security_price_technicals_mi`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'sum_period' in params and params['sum_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `sum_period` when calling `get_security_price_technicals_mi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_mi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'ema_period' in params:
            query_params.append(('ema_period', params['ema_period']))  # noqa: E501
        if 'sum_period' in params:
            query_params.append(('sum_period', params['sum_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/mi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMassIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_nvi(self, identifier, **kwargs):  # noqa: E501
        """Negative Volume Index  # noqa: E501

        The negative volume index (NVI) is often referred to as the `smart money indicator.` It works by the assumption that smart money (institutional money) is at work when volume decreases and vice versa when volume increases. NVI starts at 1000 and increases in regard to the percentage price change when volume decreases over a 255-day EMA period. Traders often use this technical indicator when researching broder markets and indices.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_nvi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityNegativeVolumeIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_nvi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_nvi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_nvi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Negative Volume Index  # noqa: E501

        The negative volume index (NVI) is often referred to as the `smart money indicator.` It works by the assumption that smart money (institutional money) is at work when volume decreases and vice versa when volume increases. NVI starts at 1000 and increases in regard to the percentage price change when volume decreases over a 255-day EMA period. Traders often use this technical indicator when researching broder markets and indices.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_nvi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityNegativeVolumeIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_nvi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_nvi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_nvi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/nvi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityNegativeVolumeIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_obv(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume  # noqa: E501

        On-balance volume (OBV) is a leading momentum indicator that uses the increase/decrease flow in volume to predict upcoming stock price changes. When both OBV and a security`s price are making higher highs, it is presumed the upward trend is likely to continue and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_obv_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_obv_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_obv_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume  # noqa: E501

        On-balance volume (OBV) is a leading momentum indicator that uses the increase/decrease flow in volume to predict upcoming stock price changes. When both OBV and a security`s price are making higher highs, it is presumed the upward trend is likely to continue and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_obv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_obv`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_obv`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/obv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityOnBalanceVolume',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_obv_mean(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume Mean  # noqa: E501

        On-balance volume mean (OBVM) is a leading momentum indicator that uses the increase/decrease flow in volume to predict upcoming stock price changes. The difference between OBV and OBVM is that OBVM takes the mean average of a provided period.  When both OBVM and a security`s price are making higher highs, it is presumed the upward trend is likely to continue and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_mean(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate On-balance Volume Mean
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolumeMean
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_obv_mean_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_obv_mean_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_obv_mean_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume Mean  # noqa: E501

        On-balance volume mean (OBVM) is a leading momentum indicator that uses the increase/decrease flow in volume to predict upcoming stock price changes. The difference between OBV and OBVM is that OBVM takes the mean average of a provided period.  When both OBVM and a security`s price are making higher highs, it is presumed the upward trend is likely to continue and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_mean_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate On-balance Volume Mean
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolumeMean
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_obv_mean" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_obv_mean`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_obv_mean`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_obv_mean`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/obv_mean', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityOnBalanceVolumeMean',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_rsi(self, identifier, **kwargs):  # noqa: E501
        """Relative Strength Index  # noqa: E501

        Relative strength index (RSI) is a momentum oscillator that ranges between 0 and 100. Traders believe that an RSI value over 70 indicates that a security is overbought and an RSI under 30 indicates that a security is oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_rsi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Relative Strength Index
        :param str price_key: The Stock Price field to use when calculating Relative Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityRelativeStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_rsi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_rsi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_rsi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Relative Strength Index  # noqa: E501

        Relative strength index (RSI) is a momentum oscillator that ranges between 0 and 100. Traders believe that an RSI value over 70 indicates that a security is overbought and an RSI under 30 indicates that a security is oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_rsi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Relative Strength Index
        :param str price_key: The Stock Price field to use when calculating Relative Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityRelativeStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_rsi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_rsi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_rsi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_rsi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/rsi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityRelativeStrengthIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_sma(self, identifier, **kwargs):  # noqa: E501
        """Simple Moving Average  # noqa: E501

        A simple moving average (SMA) adds recent prices for a specified period and divides the total by that same number of periods. SMA is typically used to indicate whether a security is in an uptrend or downtrend and can also be combined with a long-term moving average to improve the signal`s abilities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sma(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Simple Moving Average
        :param str price_key: The Stock Price field to use when calculating Simple Moving Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecuritySimpleMovingAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_sma_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_sma_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_sma_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Simple Moving Average  # noqa: E501

        A simple moving average (SMA) adds recent prices for a specified period and divides the total by that same number of periods. SMA is typically used to indicate whether a security is in an uptrend or downtrend and can also be combined with a long-term moving average to improve the signal`s abilities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sma_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Simple Moving Average
        :param str price_key: The Stock Price field to use when calculating Simple Moving Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecuritySimpleMovingAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_sma" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_sma`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_sma`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_sma`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/sma', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecuritySimpleMovingAverage',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_sr(self, identifier, **kwargs):  # noqa: E501
        """Stochastic Oscillator  # noqa: E501

        The Stochastic Oscillator (SO) is a range-bound momentum indicator that ranges from 0 to 100 and follows the velocity of the momentum itself, not the underlying price or volume. When SO is above 80 it indicates that a security is trading at the high end of its period`s high-low range and vice versa if the reading is below 20.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate %K of Stochastic Oscillator
        :param int signal_period: The number of observations, per period, to calculate the %D (the Simple Moving Average of %K) as a signal line for Stochastic Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStochasticOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_sr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_sr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_sr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Stochastic Oscillator  # noqa: E501

        The Stochastic Oscillator (SO) is a range-bound momentum indicator that ranges from 0 to 100 and follows the velocity of the momentum itself, not the underlying price or volume. When SO is above 80 it indicates that a security is trading at the high end of its period`s high-low range and vice versa if the reading is below 20.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate %K of Stochastic Oscillator
        :param int signal_period: The number of observations, per period, to calculate the %D (the Simple Moving Average of %K) as a signal line for Stochastic Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStochasticOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'signal_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_sr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_sr`")  # noqa: E501

        if 'period' in params and params['period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_sr`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'signal_period' in params and params['signal_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `signal_period` when calling `get_security_price_technicals_sr`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_sr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'signal_period' in params:
            query_params.append(('signal_period', params['signal_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/sr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityStochasticOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_trix(self, identifier, **kwargs):  # noqa: E501
        """Triple Exponential Average  # noqa: E501

        The Triple Exponential Average (TEA) is a momentum indicator used to identify when a security is oversold and overbought. By exponentially smoothing out the underlying security`s moving average, the TEA  filters out insignificant price movements. A positive TEA is often believed to indicate momentum is increasing and a negative TEA indicates that momentum is decreasing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_trix(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Exponential Moving Average for Triple Exponential Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTripleExponentialAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_trix_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_trix_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_trix_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Triple Exponential Average  # noqa: E501

        The Triple Exponential Average (TEA) is a momentum indicator used to identify when a security is oversold and overbought. By exponentially smoothing out the underlying security`s moving average, the TEA  filters out insignificant price movements. A positive TEA is often believed to indicate momentum is increasing and a negative TEA indicates that momentum is decreasing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_trix_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Exponential Moving Average for Triple Exponential Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTripleExponentialAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_trix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_trix`")  # noqa: E501

        if 'period' in params and params['period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_trix`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_trix`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/trix', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityTripleExponentialAverage',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_tsi(self, identifier, **kwargs):  # noqa: E501
        """True Strength Index  # noqa: E501

        The True Strength Index (TSI) is a momentum oscillator used to identify building trends and trend reversals, typically by signalling overbought and oversold conditions. TSI fluctuates between positive and negative values, and traders typically combine its signal with other momentum oscillators to increase its strength. When TSI crosses the signal line into positive territory it is presumed to be an entrance opportunity and vice versa when the TSI crosses into negative territory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_tsi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate low period Exponential Moving Average for smoothing in True Strength Index
        :param int high_period: The number of observations, per period, to calculate high period Exponential Moving Average for smoothing in True Strength Index
        :param str price_key: The Stock Price field to use when calculating True Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTrueStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_tsi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_tsi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_tsi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """True Strength Index  # noqa: E501

        The True Strength Index (TSI) is a momentum oscillator used to identify building trends and trend reversals, typically by signalling overbought and oversold conditions. TSI fluctuates between positive and negative values, and traders typically combine its signal with other momentum oscillators to increase its strength. When TSI crosses the signal line into positive territory it is presumed to be an entrance opportunity and vice versa when the TSI crosses into negative territory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_tsi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate low period Exponential Moving Average for smoothing in True Strength Index
        :param int high_period: The number of observations, per period, to calculate high period Exponential Moving Average for smoothing in True Strength Index
        :param str price_key: The Stock Price field to use when calculating True Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTrueStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'low_period', 'high_period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_tsi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_tsi`")  # noqa: E501

        if 'low_period' in params and params['low_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `low_period` when calling `get_security_price_technicals_tsi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'high_period' in params and params['high_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `high_period` when calling `get_security_price_technicals_tsi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_tsi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'low_period' in params:
            query_params.append(('low_period', params['low_period']))  # noqa: E501
        if 'high_period' in params:
            query_params.append(('high_period', params['high_period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/tsi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityTrueStrengthIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_uo(self, identifier, **kwargs):  # noqa: E501
        """Ultimate Oscillator  # noqa: E501

        The Ultimate Oscillator (UO) is a range bound technical indicator that moves between 0 and 100 and is calculated with 3 timeframes, typically 7, 14, and 28 day periods. When UO`s value is above 70 a security is categorized as overbought and when UO`s value is below 30 a security is categorized as oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_uo(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate the short period for Ultimate Oscillator
        :param int medium_period: The number of observations, per period, to calculate the medium period for Ultimate Oscillator
        :param int long_period: The number of observations, per period, to calculate the long period for Ultimate Oscillator
        :param float short_weight: The weight of short Buying Pressure average for Ultimate Oscillator
        :param float medium_weight: The weight of medium Buying Pressure average for Ultimate Oscillator
        :param float long_weight: The weight of long Buying Pressure average for Ultimate Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityUltimateOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_uo_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_uo_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_uo_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ultimate Oscillator  # noqa: E501

        The Ultimate Oscillator (UO) is a range bound technical indicator that moves between 0 and 100 and is calculated with 3 timeframes, typically 7, 14, and 28 day periods. When UO`s value is above 70 a security is categorized as overbought and when UO`s value is below 30 a security is categorized as oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_uo_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate the short period for Ultimate Oscillator
        :param int medium_period: The number of observations, per period, to calculate the medium period for Ultimate Oscillator
        :param int long_period: The number of observations, per period, to calculate the long period for Ultimate Oscillator
        :param float short_weight: The weight of short Buying Pressure average for Ultimate Oscillator
        :param float medium_weight: The weight of medium Buying Pressure average for Ultimate Oscillator
        :param float long_weight: The weight of long Buying Pressure average for Ultimate Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityUltimateOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'short_period', 'medium_period', 'long_period', 'short_weight', 'medium_weight', 'long_weight', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_uo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_uo`")  # noqa: E501

        if 'long_period' in params and params['long_period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `long_period` when calling `get_security_price_technicals_uo`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_uo`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'short_period' in params:
            query_params.append(('short_period', params['short_period']))  # noqa: E501
        if 'medium_period' in params:
            query_params.append(('medium_period', params['medium_period']))  # noqa: E501
        if 'long_period' in params:
            query_params.append(('long_period', params['long_period']))  # noqa: E501
        if 'short_weight' in params:
            query_params.append(('short_weight', params['short_weight']))  # noqa: E501
        if 'medium_weight' in params:
            query_params.append(('medium_weight', params['medium_weight']))  # noqa: E501
        if 'long_weight' in params:
            query_params.append(('long_weight', params['long_weight']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/uo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityUltimateOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vi(self, identifier, **kwargs):  # noqa: E501
        """Vortex Indicator  # noqa: E501

        The Vortex Indicator (VI) is composed of an uptrend line (VI+) and a downtrend line (VI-). When VI+ crosses VI- from below it typically indicates an entry into a given security. When VI- crosses VI+ from below it typically triggers an exit and that the current trend is reversing course.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Vortex Indicator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVortexIndicator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Vortex Indicator  # noqa: E501

        The Vortex Indicator (VI) is composed of an uptrend line (VI+) and a downtrend line (VI-). When VI+ crosses VI- from below it typically indicates an entry into a given security. When VI- crosses VI+ from below it typically triggers an exit and that the current trend is reversing course.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Vortex Indicator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVortexIndicator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_vi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVortexIndicator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vpt(self, identifier, **kwargs):  # noqa: E501
        """Volume-price Trend  # noqa: E501

        The volume price trend (VPT) is a technical indicator that uses price & volume to determine whether a trend is established. Typically, when a security is trending upwards, there is more volume on positive days than negative ones, and as a result VPT should be increasing on these days as well. However, if VPT fails to increase past its previous high during an outbreak, this is suggested to indicate the rally is losing strength.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vpt(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumePriceTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vpt_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vpt_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vpt_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Volume-price Trend  # noqa: E501

        The volume price trend (VPT) is a technical indicator that uses price & volume to determine whether a trend is established. Typically, when a security is trending upwards, there is more volume on positive days than negative ones, and as a result VPT should be increasing on these days as well. However, if VPT fails to increase past its previous high during an outbreak, this is suggested to indicate the rally is losing strength.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vpt_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumePriceTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vpt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vpt`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vpt`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vpt', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVolumePriceTrend',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vwap(self, identifier, **kwargs):  # noqa: E501
        """Volume Weighted Average Price  # noqa: E501

        Volume Weighted Average Price (VWAP) is a lagging technical indicator that is used in combination with a security`s price. When the underlying price rises above its VWAP, it is often interpreted as a bullish signal, and vice versa in the opposite direction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vwap(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumeWeightedAveragePrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vwap_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vwap_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vwap_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Volume Weighted Average Price  # noqa: E501

        Volume Weighted Average Price (VWAP) is a lagging technical indicator that is used in combination with a security`s price. When the underlying price rises above its VWAP, it is often interpreted as a bullish signal, and vice versa in the opposite direction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vwap_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumeWeightedAveragePrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vwap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vwap`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vwap`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vwap', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVolumeWeightedAveragePrice',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_wr(self, identifier, **kwargs):  # noqa: E501
        """Williams %R  # noqa: E501

        Williams %R is a momentum indicator used to determine overbought and oversold environments for a security and fluctuates between 0 and -100. When Williams %R is above -20 the security is considered to be overbought and when Williams %R is under -80 the security is considered to be oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_wr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to look-back when calculating Williams %R
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param float page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityWilliamsR
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_wr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_wr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_wr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Williams %R  # noqa: E501

        Williams %R is a momentum indicator used to determine overbought and oversold environments for a security and fluctuates between 0 and -100. When Williams %R is above -20 the security is considered to be overbought and when Williams %R is under -80 the security is considered to be oversold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_wr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to look-back when calculating Williams %R
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param float page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityWilliamsR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_wr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_wr`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_wr`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_wr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/wr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityWilliamsR',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
