import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for starting a job run with StartJobRun.
 *
 * @experimental
 */
export interface GlueDataBrewStartJobRunProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Glue DataBrew Job to run.
     *
     * @experimental
     */
    readonly name: string;
}
/**
 * (experimental) Start a Job run as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-databrew.html
 * @experimental
 */
export declare class GlueDataBrewStartJobRun extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GlueDataBrewStartJobRunProps);
    /**
     * Provides the Glue DataBrew Start Job Run task configuration
     * @internal
     */
    protected _renderTask(): any;
}
