"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const lindorm_generated_1 = require("./lindorm.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return lindorm_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::Lindorm::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::Lindorm::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new lindorm_generated_1.RosInstance(this, id, {
            instanceStorage: props.instanceStorage,
            resourceGroupId: props.resourceGroupId,
            zoneId: props.zoneId,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'POSTPAY' : props.instanceChargeType,
            vSwitchId: props.vSwitchId,
            coldStorage: props.coldStorage,
            period: props.period,
            diskCategory: props.diskCategory,
            instanceName: props.instanceName,
            solrNum: props.solrNum,
            solrSpec: props.solrSpec,
            vpcId: props.vpcId,
            filestoreNum: props.filestoreNum,
            securityIpList: props.securityIpList,
            lindormSpec: props.lindormSpec,
            tsdbSpec: props.tsdbSpec,
            coreSpec: props.coreSpec,
            lindormNum: props.lindormNum,
            tsdbNum: props.tsdbNum,
            filestoreSpec: props.filestoreSpec,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrJdbcUrlList = rosInstance.attrJdbcUrlList;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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