# Netskope SDK

Neskope SDK is Python library for dealing with API's to download the Netskope events. 

## Installation

Use the package manager [pip](https://pip.pypa.io/en/stable/) to install NetskopeSDK.

```bash
pip install netskopesdk
```

## Rest sdk Usage to pull the Alert & Events 

```python
from netskope.api.iterator.netskope_iterator import NetskopeIterator
from netskope.api.iterator.const import Const
from requests.exceptions import RequestException
import time

# Construct the params dict to pass the authentication details 
params = {
        Const.NSKP_TOKEN : "<REST-API-TOKEN>",
        Const.NSKP_TENANT_HOSTNAME : "<HOSTNAME>",
        Const.NSKP_EVENT_TYPE : "<EVENT-TYPE>",
        Const.NSKP_ITERATOR_NAME : "<ITERATOR-NAME>"
    }

# Create an Iterator
iterator = NetskopeIterator(params)

# Use the next() iterator to download the logs. 
# Consume the message indefinitely in a loop and ingest the data to SIEM
while True:
    response = (iterator.next())
    try:
        if response:
            data = response.json()
            if "result" in data and len(data["result"]) != 0:
                print(data)
                time.sleep(10)
            else:
                print("No response received from the iterator")
                print(data)
                time.sleep(10)
    except Exception as e:
        raise RequestException(e)
```
