from setuptools import setup, find_packages

with open('README.md', 'r') as fh:
    long_description = fh.read()

setup(
    name='classicML-python',
    version='0.5b2',
    author='Steve R. Sun',
    license='Apache Software License',
    author_email='s1638650145@gmail.com',
    description='An easy-to-use ML framework',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/sun1638650145/classicML',
    packages=find_packages(),
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
    ],
    python_requires='>=3.6',
    install_requires=[
        'matplotlib>=3.3.2',
        'numpy>=1.19.2',
        'pandas>=1.1.3',
        'psutil>=5.7.2',
    ],
)
