# acousondePy
 Translate Acousonde MT files
 
 This software lets you load any Acousonde produced MT files and convert them into easier to use formats.
- Acoustic data files are converted into wav files
- Header information is stored as csv file
- Auxiliary data if present is concatenated into one csv file

For more information on Acousonde visit the (Acousonde website)[http://www.acousonde.com/]

Currently there are 4 functions available:

- MTread() to read one MT file
- spec_plot(p,HEADER,INFO) to create a spectrogram plot
- read_multiple_MT() to read a list of MT files
- acousonde() starts a GUI which allows you to convert slected MT files


A single Windows executable file of acousonde() which can be used without the need of any programming/scripting and does not require the user to have Python isnstalled can be obtained from (Sourceforge)[https://sourceforge.net/projects/acousonde2wav/].

# Installation  

```
pip install acousondePy
```
If you have a previous version of acousondePy installed upgrade the package:

```
pip install acousondePy -U
```

# Licence
This software is free to use.

    MIT License
    
    Copyright (c) 2020 Sven Gastauer

    Permission is hereby granted, free of charge, to any person obtaining a copy of this 
    software and associated documentation files (the "Software"), to deal in the Software 
    without restriction, including without limitation the rights to use, copy, modify, 
    merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit 
    persons to whom the Software is furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in all copies 
    or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
    PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION 
    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# Examples

For a full example have a look at the Notebooks in the notebook folder.

```python
import acousondePy as ap
import glob

#get example file dir
pdir = ap.__path__[0]

#get list of example files
fns = glob.glob(pdir + '\\\data\*.MT')

#read an acoustic MT file
p, HEADER, INFO = ap.MTread(fns[4])

#create a spectrogram plot
_=ap.spec_plot(p, HEADER, INFO)

#read multiple MT files
ap.read_multiple_MT(fns)
```

