[![github](https://img.shields.io/github/stars/zvtvz/jqdatapy.svg)](https://github.com/zvtvz/jqdatapy)
[![image](https://img.shields.io/pypi/v/jqdatapy.svg)](https://pypi.org/project/jqdatapy/)
[![image](https://img.shields.io/pypi/l/jqdatapy.svg)](https://pypi.org/project/jqdatapy/)
[![image](https://img.shields.io/pypi/pyversions/jqdatapy.svg)](https://pypi.org/project/jqdatapy/)
[![Build Status](https://api.travis-ci.org/zvtvz/jqdatapy.svg?branch=master)](https://travis-ci.org/zvtvz/jqdatapy)
[![HitCount](http://hits.dwyl.com/zvtvz/jqdatapy.svg)](http://hits.dwyl.com/zvtvz/jqdatapy)

### 说明
jqdatapy为聚宽数据[http接口](https://dataapi.joinquant.com/docs)的python封装，为官方[jqdatasdk](https://github.com/JoinQuant/jqdatasdk)的轻量替代。

其目的在于减少依赖，解决版本冲突，在[zvt](https://github.com/zvtvz/zvt)中用于数据的本地化，

### 特性
* 原始封装，方法名和字段跟官方文档一致
* 自动化保留token，按需请求
* 只依赖requests和pandas(可用最新版)

### 安装
```
pip install jqdatapy

pip show jqdatapy
```

更新到最新版本
```
pip install --upgrade jqdatapy
```

###  使用

#### 初始化环境，会自动本地化token
```
In [1]: from jqdatapy import *
In [2]: init_env(username='聚宽注册手机',password='密码')
```

#### api使用
```
In [5]: print(get_bars(code='000338.XSHE'))
   ...: print(get_all_securities())
   ...: print(get_trade_days())
   ...: print(get_trade_days())
   ...: print(get_fundamentals(count=10))
   ...: print(get_mtss())
   ...: print(run_query(count=10, parse_dates=None))
        date   open  close   high    low     volume         money  paused  high_limit  low_limit    avg  pre_close
0 2020-09-14  14.24  14.35  14.43  14.22   24556166  3.514904e+08       0       15.59      12.75  14.31      14.17
1 2020-09-15  14.35  14.90  14.95  14.31   56693203  8.360576e+08       0       15.79      12.92  14.75      14.35
2 2020-09-16  14.83  15.02  15.34  14.75   49258551  7.402552e+08       0       16.39      13.41  15.03      14.90
3 2020-09-17  15.19  16.18  16.30  15.19  130136055  2.063710e+09       0       16.52      13.52  15.86      15.02
4 2020-09-18  16.35  16.59  16.65  16.23  112580041  1.854240e+09       0       17.80      14.56  16.47      16.18
5 2020-09-21  16.60  16.00  16.62  15.84   69804961  1.123414e+09       0       18.25      14.93  16.09      16.59
6 2020-09-22  15.85  15.62  16.04  15.54   50336697  7.942570e+08       0       17.60      14.40  15.78      16.00
7 2020-09-23  15.69  15.48  15.75  15.34   46083422  7.135471e+08       0       17.18      14.06  15.48      15.62
8 2020-09-24  15.34  15.08  15.37  15.04   37973611  5.750271e+08       0       17.03      13.93  15.14      15.48
9 2020-09-25  15.20  14.92  15.20  14.91   18540881  2.786308e+08       0       16.59      13.57  15.03      15.08
             code display_name  name  start_date    end_date   type
0     000001.XSHE         平安银行  PAYX  1991-04-03  2200-01-01  stock
1     000002.XSHE          万科A   WKA  1991-01-29  2200-01-01  stock
2     000004.XSHE         国农科技  GNKJ  1990-12-01  2200-01-01  stock
3     000005.XSHE         世纪星源  SJXY  1990-12-10  2200-01-01  stock
4     000006.XSHE         深振业A  SZYA  1992-04-27  2200-01-01  stock
...           ...          ...   ...         ...         ...    ...
4126  688596.XSHG         正帆科技  ZFKJ  2020-08-20  2200-01-01  stock
4127  688598.XSHG         金博股份  JBGF  2020-05-18  2200-01-01  stock
4128  688599.XSHG         天合光能  THGN  2020-06-10  2200-01-01  stock
4129  688600.XSHG         皖仪科技  WYKJ  2020-07-03  2200-01-01  stock
4130  688981.XSHG         中芯国际  ZXGJ  2020-07-16  2200-01-01  stock

[4131 rows x 6 columns]
               0
0     2004-11-08
1     2004-11-09
2     2004-11-10
3     2004-11-11
4     2004-11-12
...          ...
3861  2020-09-21
3862  2020-09-22
3863  2020-09-23
3864  2020-09-24
3865  2020-09-25

[3866 rows x 1 columns]
               0
0     2004-11-08
1     2004-11-09
2     2004-11-10
3     2004-11-11
4     2004-11-12
...          ...
3861  2020-09-21
3862  2020-09-22
3863  2020-09-23
3864  2020-09-24
3865  2020-09-25

[3866 rows x 1 columns]
           id         code        day     pubDate    statDate periodStart  ... retained_profit  foreign_currency_report_conv_diff  equities_parent_company_owners  minority_interests  total_owner_equities  total_sheet_owner_equities
0  28053040.0  000001.XSHE 2020-09-16  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
1  28053042.0  000001.XSHE 2020-09-17  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
2  28053044.0  000001.XSHE 2020-09-18  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
3  28053044.0  000001.XSHE 2020-09-19  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
4  28053044.0  000001.XSHE 2020-09-20  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
5  28053046.0  000001.XSHE 2020-09-21  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
6  28053048.0  000001.XSHE 2020-09-22  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
7  28053048.0  000001.XSHE 2020-09-23  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
8  28053048.0  000001.XSHE 2020-09-24  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12
9  28053050.0  000001.XSHE 2020-09-25  2020-08-28  2020-06-30  2020-08-28  ...    1.219440e+11                                NaN                    3.513970e+11                 NaN          3.513970e+11                4.178622e+12

[10 rows x 89 columns]
           date     sec_code   fin_value  fin_buy_value  fin_refund_value  sec_value  sec_sell_value  sec_refund_value  fin_sec_value
0    2010-03-31  000001.XSHE        4730           4730                 0       2100            2100                 0          53450
1    2010-04-01  000001.XSHE        4730              0                 0          0               0              2100           4730
2    2010-04-02  000001.XSHE        4712           2347              2365          0               0                 0           4712
3    2010-04-06  000001.XSHE        4712              0                 0          0               0                 0           4712
4    2010-04-07  000001.XSHE        4712              0                 0          0               0                 0           4712
...         ...          ...         ...            ...               ...        ...             ...               ...            ...
2548 2020-09-18  000001.XSHE  3919556191      238189827         270275976   67512142          120200            234200     5004476313
2549 2020-09-21  000001.XSHE  3849371241      108081360         178266310   66813349          429500           1128293     4909030957
2550 2020-09-22  000001.XSHE  3855420696      106478290         100428835   70238849         3559400            133900     4949039576
2551 2020-09-23  000001.XSHE  3744883578       71282484         181819602   71950394         1788079             76534     4869468236
2552 2020-09-24  000001.XSHE  3771133403      113139423          86889598   72439450         1561856           1072800     4866417887

[2553 rows x 9 columns]
   id  exchange_code exchange_name        date  total_market_cap  circulating_market_cap      volume      money  deal_number  pe_average  turnover_ratio
0   1         322002          上海A股  2005-01-04      25228.240618             6941.067590  80648.3466  43.888276      42.2473      23.817          0.6368
1   2         322003          上海B股  2005-01-04        298.830614              298.830614   1019.3588   0.311245       0.4442      20.065          0.1018
2   3         322001          上海市场  2005-01-04      25527.071233             7239.898204  81667.7054  44.199521      42.6915      23.768          0.5976
3   4         322006         中小企业板  2005-01-04        409.450000              118.850000    800.0000   1.190000       1.4600      31.030             NaN
4   5         322004          深圳市场  2005-01-04      10859.540000             4279.140000         NaN  24.740000          NaN      24.220          0.5300
5   6         322002          上海A股  2005-01-05      25408.493484             7022.186703  85238.5339  48.680153      52.7249      23.978          0.6731
6   7         322003          上海B股  2005-01-05        306.795402              306.795402   1597.9846   0.500740       0.6206      20.629          0.1595
7   8         322001          上海市场  2005-01-05      25715.288885             7328.982104  86836.5185  49.180893      53.3455      23.934          0.6354
8   9         322006         中小企业板  2005-01-05        415.900000              120.760000   1000.0000   1.370000       1.6800      31.520             NaN
9  10         322004          深圳市场  2005-01-05      11021.380000             4347.240000         NaN  30.500000          NaN      24.570          0.6700
```
### 联系

微信 foolcage