/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructCodeAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructModuleAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructRecordAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructGeneralAttribute {
    public static final Key<StructCodeAttribute> ATTRIBUTE_CODE = new Key("Code");
    public static final Key<StructInnerClassesAttribute> ATTRIBUTE_INNER_CLASSES = new Key("InnerClasses");
    public static final Key<StructGenericSignatureAttribute> ATTRIBUTE_SIGNATURE = new Key("Signature");
    public static final Key<StructAnnDefaultAttribute> ATTRIBUTE_ANNOTATION_DEFAULT = new Key("AnnotationDefault");
    public static final Key<StructExceptionsAttribute> ATTRIBUTE_EXCEPTIONS = new Key("Exceptions");
    public static final Key<StructEnclosingMethodAttribute> ATTRIBUTE_ENCLOSING_METHOD = new Key("EnclosingMethod");
    public static final Key<StructAnnotationAttribute> ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS = new Key("RuntimeVisibleAnnotations");
    public static final Key<StructAnnotationAttribute> ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS = new Key("RuntimeInvisibleAnnotations");
    public static final Key<StructAnnotationParameterAttribute> ATTRIBUTE_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = new Key("RuntimeVisibleParameterAnnotations");
    public static final Key<StructAnnotationParameterAttribute> ATTRIBUTE_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = new Key("RuntimeInvisibleParameterAnnotations");
    public static final Key<StructTypeAnnotationAttribute> ATTRIBUTE_RUNTIME_VISIBLE_TYPE_ANNOTATIONS = new Key("RuntimeVisibleTypeAnnotations");
    public static final Key<StructTypeAnnotationAttribute> ATTRIBUTE_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = new Key("RuntimeInvisibleTypeAnnotations");
    public static final Key<StructLocalVariableTableAttribute> ATTRIBUTE_LOCAL_VARIABLE_TABLE = new Key("LocalVariableTable");
    public static final Key<StructLocalVariableTypeTableAttribute> ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE = new Key("LocalVariableTypeTable");
    public static final Key<StructConstantValueAttribute> ATTRIBUTE_CONSTANT_VALUE = new Key("ConstantValue");
    public static final Key<StructBootstrapMethodsAttribute> ATTRIBUTE_BOOTSTRAP_METHODS = new Key("BootstrapMethods");
    public static final Key<StructGeneralAttribute> ATTRIBUTE_SYNTHETIC = new Key("Synthetic");
    public static final Key<StructGeneralAttribute> ATTRIBUTE_DEPRECATED = new Key("Deprecated");
    public static final Key<StructLineNumberTableAttribute> ATTRIBUTE_LINE_NUMBER_TABLE = new Key("LineNumberTable");
    public static final Key<StructMethodParametersAttribute> ATTRIBUTE_METHOD_PARAMETERS = new Key("MethodParameters");
    public static final Key<StructModuleAttribute> ATTRIBUTE_MODULE = new Key("Module");
    public static final Key<StructRecordAttribute> ATTRIBUTE_RECORD = new Key("Record");

    public static StructGeneralAttribute createAttribute(String name) {
        if (StructGeneralAttribute.ATTRIBUTE_CODE.name.equals(name)) {
            return new StructCodeAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES.name.equals(name)) {
            return new StructInnerClassesAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_CONSTANT_VALUE.name.equals(name)) {
            return new StructConstantValueAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_SIGNATURE.name.equals(name)) {
            return new StructGenericSignatureAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_ANNOTATION_DEFAULT.name.equals(name)) {
            return new StructAnnDefaultAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_EXCEPTIONS.name.equals(name)) {
            return new StructExceptionsAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD.name.equals(name)) {
            return new StructEnclosingMethodAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS.name.equals(name) || StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS.name.equals(name)) {
            return new StructAnnotationAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS.name.equals(name) || StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS.name.equals(name)) {
            return new StructAnnotationParameterAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.name.equals(name) || StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS.name.equals(name)) {
            return new StructTypeAnnotationAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name.equals(name)) {
            return new StructLocalVariableTableAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name.equals(name)) {
            return new StructLocalVariableTypeTableAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS.name.equals(name)) {
            return new StructBootstrapMethodsAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_SYNTHETIC.name.equals(name) || StructGeneralAttribute.ATTRIBUTE_DEPRECATED.name.equals(name)) {
            return new StructGeneralAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_LINE_NUMBER_TABLE.name.equals(name)) {
            return new StructLineNumberTableAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS.name.equals(name)) {
            return new StructMethodParametersAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_MODULE.name.equals(name)) {
            return new StructModuleAttribute();
        }
        if (StructGeneralAttribute.ATTRIBUTE_RECORD.name.equals(name)) {
            return new StructRecordAttribute();
        }
        return null;
    }

    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
    }

    public static class Key<T extends StructGeneralAttribute> {
        public final String name;

        public Key(String name) {
            this.name = name;
        }
    }
}

