/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;

public final class SwitchHelper {
    public static void simplify(SwitchStatement switchStatement) {
        SwitchExprent switchExprent = (SwitchExprent)switchStatement.getHeadexprent();
        Exprent value = switchExprent.getValue();
        if (SwitchHelper.isEnumArray(value)) {
            MethodWrapper wrapper;
            List<List<Exprent>> caseValues = switchStatement.getCaseValues();
            HashMap mapping = new HashMap(caseValues.size());
            ArrayExprent array = (ArrayExprent)value;
            FieldExprent arrayField = (FieldExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
            if (classNode != null && (wrapper = classNode.getWrapper().getMethodWrapper("<clinit>", "()V")) != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1 && ((ArrayExprent)left).getArray().equals(arrayField)) {
                            mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                        }
                    }
                    return 0;
                });
            }
            ArrayList realCaseValues = new ArrayList(caseValues.size());
            for (List<Exprent> caseValue : caseValues) {
                ArrayList<Exprent> values = new ArrayList<Exprent>(caseValue.size());
                realCaseValues.add(values);
                for (Exprent exprent2 : caseValue) {
                    if (exprent2 == null) {
                        values.add(null);
                        continue;
                    }
                    Exprent realConst = (Exprent)mapping.get(exprent2);
                    if (realConst == null) {
                        DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + exprent2 + " not found, available: " + mapping, IFernflowerLogger.Severity.ERROR);
                        return;
                    }
                    values.add(realConst.copy());
                }
            }
            caseValues.clear();
            caseValues.addAll(realCaseValues);
            switchExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
        }
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (exprent instanceof ArrayExprent) {
            Exprent field = ((ArrayExprent)exprent).getArray();
            Exprent index = ((ArrayExprent)exprent).getIndex();
            return field instanceof FieldExprent && (((FieldExprent)field).getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal"));
        }
        return false;
    }
}

