/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.modules.renamer.ConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.IdentifierConverter;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class Fernflower
implements IDecompiledData {
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private final IIdentifierRenamer helper;
    private final IdentifierConverter converter;

    public Fernflower(IBytecodeProvider provider, IResultSaver saver, Map<String, Object> customProperties, IFernflowerLogger logger) {
        String level;
        HashMap<String, Object> properties = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        if (customProperties != null) {
            properties.putAll(customProperties);
        }
        if ((level = (String)properties.get("log")) != null) {
            try {
                logger.setSeverity(IFernflowerLogger.Severity.valueOf(level.toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.structContext = new StructContext(saver, this, new LazyLoader(provider));
        this.classProcessor = new ClassesProcessor(this.structContext);
        PoolInterceptor interceptor = null;
        if ("1".equals(properties.get("ren"))) {
            this.helper = Fernflower.loadHelper((String)properties.get("urc"), logger);
            interceptor = new PoolInterceptor();
            this.converter = new IdentifierConverter(this.structContext, this.helper, interceptor);
        } else {
            this.helper = null;
            this.converter = null;
        }
        DecompilerContext context = new DecompilerContext(properties, logger, this.structContext, this.classProcessor, interceptor);
        DecompilerContext.setCurrentContext(context);
    }

    private static IIdentifierRenamer loadHelper(String className, IFernflowerLogger logger) {
        if (className != null) {
            try {
                Class<?> renamerClass = Fernflower.class.getClassLoader().loadClass(className);
                return (IIdentifierRenamer)renamerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.writeMessage("Cannot load renamer '" + className + "'", IFernflowerLogger.Severity.WARN, e);
            }
        }
        return new ConverterHelper();
    }

    public void addSource(File source) {
        this.structContext.addSpace(source, true);
    }

    public void addLibrary(File library) {
        this.structContext.addSpace(library, false);
    }

    public void decompileContext() {
        if (this.converter != null) {
            this.converter.rename();
        }
        this.classProcessor.loadClasses(this.helper);
        this.structContext.saveContext();
    }

    public void clearContext() {
        DecompilerContext.setCurrentContext(null);
    }

    @Override
    public String getClassEntryName(StructClass cl, String entryName) {
        ClassesProcessor.ClassNode node = this.classProcessor.getMapRootClasses().get(cl.qualifiedName);
        if (node.type != 0) {
            return null;
        }
        if (this.converter != null) {
            String simpleClassName = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf(47) + 1);
            return entryName.substring(0, entryName.lastIndexOf(47) + 1) + simpleClassName + ".java";
        }
        return entryName.substring(0, entryName.lastIndexOf(".class")) + ".java";
    }

    @Override
    public String getClassContent(StructClass cl) {
        try {
            TextBuffer buffer = new TextBuffer(16384);
            buffer.append(DecompilerContext.getProperty("ban").toString());
            this.classProcessor.writeClass(cl, buffer);
            return buffer.toString();
        }
        catch (Throwable t) {
            DecompilerContext.getLogger().writeMessage("Class " + cl.qualifiedName + " couldn't be fully decompiled.", t);
            return null;
        }
    }
}

