/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.rule.status;

import com.github.viclovsky.swagger.coverage.core.model.Condition;
import com.github.viclovsky.swagger.coverage.core.model.SinglePredicateCondition;
import com.github.viclovsky.swagger.coverage.core.predicate.DefaultStatusConditionPredicate;
import com.github.viclovsky.swagger.coverage.core.rule.status.StatusConditionRule;

public class HTTPStatusRule
extends StatusConditionRule {
    @Override
    public String getId() {
        return "status";
    }

    @Override
    public Condition processStatus(String status) {
        if (this.skip(status)) {
            return null;
        }
        DefaultStatusConditionPredicate predicate = new DefaultStatusConditionPredicate(status);
        return new SinglePredicateCondition("HTTP status " + status, "", predicate);
    }

    protected boolean skip(String status) {
        if (this.options == null) {
            return false;
        }
        if (this.options.getFilter() != null && !this.options.getFilter().isEmpty() && !this.options.getFilter().contains(status)) {
            return true;
        }
        return this.options.getIgnore() != null && !this.options.getIgnore().isEmpty() && this.options.getIgnore().contains(status);
    }
}

