/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.rule.body;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.model.Condition;
import com.github.viclovsky.swagger.coverage.core.model.SinglePredicateCondition;
import com.github.viclovsky.swagger.coverage.core.predicate.PropertyValueConditionPredicate;
import com.github.viclovsky.swagger.coverage.core.rule.body.PropertyConditionRule;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;

public class PropertyEnumAllValuesRule
extends PropertyConditionRule {
    @Override
    protected Condition processProperty(String mediaTypeName, String name, Schema schema) {
        List<String> enums = SwaggerSpecificationProcessor.extractEnum(schema);
        if (schema != null && name != null && mediaTypeName != null && enums != null && !enums.isEmpty()) {
            return new SinglePredicateCondition(String.format("\u00ab%s\u00bb contains all values from enum %s", name, enums), "", new PropertyValueConditionPredicate(mediaTypeName, name, enums));
        }
        return null;
    }

    @Override
    public String getId() {
        return "property-enum-all-value";
    }
}

