/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.generator;

import com.github.viclovsky.swagger.coverage.FileSystemOutputReader;
import com.github.viclovsky.swagger.coverage.configuration.Configuration;
import com.github.viclovsky.swagger.coverage.configuration.ConfigurationBuilder;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsBuilder;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Generator.class);
    private Path specPath;
    private Path inputPath;
    private Path configurationPath;
    private OpenAPIParser parser = new OpenAPIParser();
    private List<StatisticsBuilder> statisticsBuilders = new ArrayList<StatisticsBuilder>();

    public void run() {
        SwaggerParseResult parsed = this.parser.readLocation(this.getSpecPath().toUri().toString(), null, null);
        parsed.getMessages().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        OpenAPI spec = parsed.getOpenAPI();
        LOGGER.info("spec is {}", (Object)spec);
        Configuration configuration = ConfigurationBuilder.build(this.configurationPath);
        this.statisticsBuilders = configuration.getStatisticsBuilders(spec);
        FileSystemOutputReader reader = new FileSystemOutputReader(this.getInputPath());
        reader.getOutputs().forEach(o -> this.processFile((Path)o));
        Results result = new Results();
        this.statisticsBuilders.stream().filter(StatisticsBuilder::isPreBuilder).forEach(statisticsBuilder -> statisticsBuilder.build(result, configuration));
        this.statisticsBuilders.stream().filter(StatisticsBuilder::isPostBuilder).forEach(statisticsBuilder -> statisticsBuilder.build(result, configuration));
        configuration.getConfiguredResultsWriters().forEach(writer -> writer.write(result));
    }

    public void processFile(Path path) {
        SwaggerParseResult parsed = this.parser.readLocation(path.toUri().toString(), null, null);
        parsed.getMessages().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        OpenAPI spec = parsed.getOpenAPI();
        this.statisticsBuilders.stream().filter(StatisticsBuilder::isPreBuilder).forEach(builder -> builder.add(path.toString()).add(spec));
    }

    public Path getSpecPath() {
        return this.specPath;
    }

    public Generator setSpecPath(Path specPath) {
        this.specPath = specPath;
        return this;
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Generator setInputPath(Path inputPath) {
        this.inputPath = inputPath;
        return this;
    }

    public Path getConfigurationPath() {
        return this.configurationPath;
    }

    public Generator setConfigurationPath(Path configurationPath) {
        this.configurationPath = configurationPath;
        return this;
    }
}

