/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.configuration;

import com.github.viclovsky.swagger.coverage.configuration.options.ConfigurationOptions;
import com.github.viclovsky.swagger.coverage.configuration.options.RuleConfigurationOptions;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsBuilder;
import com.github.viclovsky.swagger.coverage.core.rule.core.ConditionRule;
import com.github.viclovsky.swagger.coverage.core.writer.CoverageResultsWriter;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.stream.Collectors;

public class Configuration {
    protected ConfigurationOptions options = new ConfigurationOptions();
    private List<ConditionRule> defaultRules;
    private List<StatisticsBuilder> registeredBuilders;
    private List<ConditionRule> configuredRules = null;
    private List<StatisticsBuilder> configuredBuilders = null;
    private List<CoverageResultsWriter> configuredResultsWriters = null;

    public List<ConditionRule> getRulesList() {
        if (this.configuredRules == null) {
            this.configuredRules = this.defaultRules.stream().filter(rule -> this.enableByRuleOptions(rule.getId())).map(rule -> rule.configure(this.options.getRules().getOrDefault(rule.getId(), new RuleConfigurationOptions()))).collect(Collectors.toList());
        }
        return this.configuredRules;
    }

    public List<StatisticsBuilder> getStatisticsBuilders(OpenAPI specification) {
        if (this.configuredBuilders == null) {
            this.configuredBuilders = this.registeredBuilders.stream().map(builder -> builder.configure(this.options).configure(specification, this.getRulesList())).collect(Collectors.toList());
        }
        return this.configuredBuilders;
    }

    protected boolean enableByRuleOptions(String id) {
        RuleConfigurationOptions option = this.options.getRules().get(id);
        if (option != null) {
            return option.isEnable();
        }
        return true;
    }

    public Configuration setOptions(ConfigurationOptions options) {
        this.options = options;
        return this;
    }

    public RuleConfigurationOptions getOption(String optionKey) {
        return this.options.getRules().get(optionKey);
    }

    public Configuration setDefaultRules(List<ConditionRule> defaultRules) {
        this.defaultRules = defaultRules;
        return this;
    }

    public Configuration setRegisteredBuilders(List<StatisticsBuilder> registeredBuilders) {
        this.registeredBuilders = registeredBuilders;
        return this;
    }

    public List<StatisticsBuilder> getConfiguredBuilders() {
        return this.configuredBuilders;
    }

    public Configuration setConfiguredBuilders(List<StatisticsBuilder> configuredBuilders) {
        this.configuredBuilders = configuredBuilders;
        return this;
    }

    public List<CoverageResultsWriter> getConfiguredResultsWriters() {
        return this.configuredResultsWriters;
    }

    public Configuration setConfiguredResultsWriters(List<CoverageResultsWriter> configuredResultsWriters) {
        this.configuredResultsWriters = configuredResultsWriters;
        return this;
    }
}

