import { TeX } from "./math_text";
import { isString } from "../../core/util/types";
export function is_tex_string(text) {
    if (!isString(text))
        return false;
    const dollars = /^\$\$.*?\$\$$/s;
    const braces = /^\\\[.*?\\\]$/s;
    const parens = /^\\\(.*?\\\)$/s;
    return dollars.test(text) || braces.test(text) || parens.test(text);
}
export function tex_from_text_like(text) {
    if (text instanceof TeX)
        return text;
    if (isString(text) && is_tex_string(text))
        return new TeX({ text: text.slice(2, -2) });
    return null;
}
//# sourceMappingURL=utils.js.map