# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/01_DataPipes/01h_pipes.map.transforms.ipynb.

# %% auto 0
__all__ = ['T_co', 'TypeTransformer']

# %% ../../../nbs/01_DataPipes/01h_pipes.map.transforms.ipynb 3
# Python native modules
from typing import Callable,Union,TypeVar
# Third party libs
from fastcore.all import *
import torchdata.datapipes as dp
from torchdata.datapipes.map import MapDataPipe
from torchdata.dataloader2.graph import find_dps,DataPipeGraph,Type,DataPipe
# Local modules

# %% ../../../nbs/01_DataPipes/01h_pipes.map.transforms.ipynb 5
T_co = TypeVar("T_co", covariant=True)

class TypeTransformer(dp.map.MapDataPipe):
    def __init__(
            self,
            # Should allow `__getitem__` and producing elements to be injested by `type_tfms`
            source_datapipe:MapDataPipe[T_co],
            # A list of Callables that accept an input, and return an output
            type_tfms:List[Callable]
    ) -> None:
        self.type_tfms:Pipeline[Callable] = Pipeline(type_tfms)
        self.source_datapipe:MapDataPipe[T_co] = source_datapipe
    
    def __getitem__(self, index) -> T_co:
        data = self.source_datapipe[index]
        return self.type_tfms(data)
            
    def __len__(self) -> int: return len(self.source_datapipe)

TypeTransformer.__doc__ = """On `__getitem__` functions in `self.type_tfms` get called over each element.
Generally `TypeTransformer` as the name suggests is intended to convert elements from one type to another.
reference documentation on how to combine this with `InMemoryCacheHolder`."""
