# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/01_DataPipes/01g_pipes.iter.transforms.ipynb.

# %% auto 0
__all__ = ['T_co', 'ItemTransformer', 'BatchTransformer']

# %% ../../../nbs/01_DataPipes/01g_pipes.iter.transforms.ipynb 3
# Python native modules
from typing import Callable,Union,TypeVar
# Third party libs
from fastcore.all import *
import torchdata.datapipes as dp
from torchdata.datapipes.iter import IterDataPipe
from torchdata.dataloader2.graph import find_dps,DataPipeGraph,Type,DataPipe
# Local modules

# %% ../../../nbs/01_DataPipes/01g_pipes.iter.transforms.ipynb 5
T_co = TypeVar("T_co", covariant=True)

class ItemTransformer(IterDataPipe[T_co]):
    def __init__(
            self,
            # Should allow iterating and producing elements to be injested by `item_tfms`
            source_datapipe:IterDataPipe[T_co],
            # A list of Callables that accept an input, and return an output
            item_tfms:List[Callable]
    ) -> None: 
        self.item_tfms:Pipeline[Callable] = Pipeline(item_tfms)
        self.source_datapipe:IterDataPipe[T_co] = source_datapipe
    
    def __iter__(self) -> Iterator[T_co]:
        for data in self.source_datapipe:
            yield self.item_tfms(data)
    
ItemTransformer.__doc__ = """Converts `item_tfms` into a `Pipeline` that is run over for every iter in `source_datapipe`"""

# %% ../../../nbs/01_DataPipes/01g_pipes.iter.transforms.ipynb 8
class BatchTransformer(IterDataPipe[T_co]):
    def __init__(
            self,
            # Should allow iterating and producing batches of elements to be injested by `batch_tfms`
            source_datapipe:IterDataPipe[T_co],
            # A list of Callables that accept a (batch) input, and return an (batch) output
            batch_tfms:List[Callable]
    ) -> None:
        self.batch_tfms:Pipeline[Callable] = Pipeline(batch_tfms)
        self.source_datapipe:IterDataPipe[T_co] = source_datapipe
    
    def __iter__(self) -> Iterator[T_co]:
        for data in self.source_datapipe:
            yield self.batch_tfms(data)
            
BatchTransformer.__doc__ = """Converts `batch_tfms` into a `Pipeline` that is run over for every iter in `source_datapipe`"""
