# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/02_DataLoading/02g_data.block.ipynb.

# %% auto 0
__all__ = ['DataPipeOrDataLoader', 'TransformBlock', 'InvalidTransformBlock', 'validate_transform_block',
           'DataPipeWrapperTransformBlock', 'DataBlock']

# %% ../../nbs/02_DataLoading/02g_data.block.ipynb 3
# Python native modules
import os
import inspect
from typing import Any,Callable,Generator
from inspect import isfunction,ismethod
import pickle
# Third party libs
from fastcore.all import *
from torchdata.dataloader2.dataloader2 import DataLoader2
from torchdata.dataloader2.graph import find_dps,traverse,DataPipe,IterDataPipe,MapDataPipe
from ..torch_core import *

import torchdata.datapipes as dp
from collections import deque

# Local modules
from ..pipes.core import *
from ..core import *
from .dataloader2 import *

# %% ../../nbs/02_DataLoading/02g_data.block.ipynb 6
DataPipeOrDataLoader = Union[DataPipe,DataLoader2]
class TransformBlock(Callable[[Union[Iterable,DataPipe]],DataPipeOrDataLoader]):...

# %% ../../nbs/02_DataLoading/02g_data.block.ipynb 13
class InvalidTransformBlock(Exception):pass

def validate_transform_block(block:TransformBlock):
    msg = f"Checked {block}:"
    failed = False 
    kwargs = dict(inspect.signature(block).parameters)
    msg += f'\nGiven kwargs: {kwargs}'
    msg += f'\nGiven return: {inspect.signature(block).return_annotation}'
    if 'source' not in kwargs:
        failed = True
        msg += f'\n`source:Any` is missing from the arguments'
    if 'as_dataloader' not in kwargs:
        failed = True
        msg += f'\n`as_dataloader:bool=False` is missing from the arguments'
    if inspect.signature(block).return_annotation != DataPipeOrDataLoader:
        failed = True
        msg += f'\n`DataPipeOrDataLoader` missing from return signature'
    if failed: raise InvalidTransformBlock(msg)

# %% ../../nbs/02_DataLoading/02g_data.block.ipynb 18
class DataPipeWrapperTransformBlock():

    def __init__(self,
        dp_cls:DataPipe, # The `DataPipe` to wrap into a `TransformBlock`,
        **dp_kwargs
    ) -> None:
        "Used by `DataBlock` to support converting `DataPipe`s to `TransformBlock`s on the fly."
        store_attr()
        self.dp_kwargs = dp_kwargs
    
    def __call__(
        self,
        # `source` likely will be an iterable that gets pushed into the pipeline when an 
        # experiment is actually being run.
        source:Any,
        # Any parameters needed for the dataloader
        num_workers:int=0,
        # If True, returns a `DataLoader2` instead of `DataPipe`
        as_dataloader:bool=False
    ) -> DataPipeOrDataLoader:

        pipe = self.dp_cls(source,**self.dp_kwargs) 
        if as_dataloader:
            pipe = DataLoader2(
                datapipe=pipe,
                reading_service=PrototypeMultiProcessingReadingService(
                    num_workers = num_workers,
                    protocol_client_type = InputItemIterDataPipeQueueProtocolClient,
                    protocol_server_type = InputItemIterDataPipeQueueProtocolServer,
                    pipe_type = item_input_pipe_type,
                    eventloop = SpawnProcessForDataPipeline
                ) if num_workers>0 else None
            )
        return pipe 

# %% ../../nbs/02_DataLoading/02g_data.block.ipynb 22
_DataBlock_msg = """Interpreting `blocks` input as %s, resulting in %s dataloaders"""

class DataBlock(object):
    def __init__(
        self,
        # A tuple of `TransformBlock`s to convert to `DataPipe`s or `DataLoader2`s.
        *blocks:Tuple[Union[Tuple[TransformBlock],TransformBlock]],
        # Debug mode for verbose output
        debug:bool=False
    ):
        self.blocks = blocks 

        if debug:
            block_types = [['datapipe','datapipe_group'][type(b)==tuple] for b in blocks]
            print(_DataBlock_msg%(block_types, len(blocks)))

    def blocks2dp_or_dl(self,
            # Passed into the `blocks`, likely as an iterable.
            source:Any,
            # Single `TransformBlock` or tuples of `TransformBlock`s that are
            # executed and chained together into a single `DataPipe`.
            blocks:Union[TransformBlock,Tuple[TransformBlock]],
            # If True, a `DataLoader2` instance is returned instead of a `DataPipe`  
            as_dataloader:bool=False,
            # Number of workers to use for the dataloader.
            # Requires `as_dataloader=True`
            num_workers:int=0
        ) -> DataPipeOrDataLoader:
        if type(blocks)!=tuple:
            validate_transform_block(blocks)
            pipe = blocks(source,as_dataloader=as_dataloader,num_workers=num_workers)
        elif len(blocks)==1:
            validate_transform_block(blocks[0])
            pipe = blocks[0](source,as_dataloader=as_dataloader,num_workers=num_workers)
        else:
            for b in blocks: validate_transform_block(b)
            pipe = blocks[0](source)
            for sub_block in blocks[1:-1]: pipe = sub_block(pipe)
            pipe = blocks[-1](pipe,as_dataloader=as_dataloader,num_workers=num_workers)
        return pipe


    def datapipes(self,source:Any):
        return tuple(self.blocks2dp_or_dl(source,b) for b in self.blocks)

    def dataloaders(self,source:Any,num_workers=0):
        return tuple(
            self.blocks2dp_or_dl(source,b,as_dataloader=True,num_workers=num_workers) 
            for b in self.blocks
        )


add_docs(DataBlock,
"""`DataBlock` is a single object for constructing datapipes and dataloaders from `blocks`.
Below are examples on how `blocks` eventually get converted to dataloaders.

Example 1: Simplest
blocks = (
    TestTransformBlock,
    TestTransformBlock
) -> (
    DataLoader2(TestTransformBlock(as_dataloader=True)),
    DataLoader2(TestTransformBlock(as_dataloader=True))
)

Example 2: Nested Blocks
blocks = (
    (TestTransformBlock,TestTransformBlock2),
    TestTransformBlock
) -> (
    DataLoader2(TestTransformBlock -> TestTransformBlock2(as_dataloader=True)),
    DataLoader2(TestTransformBlock)
)

In example 2, we can nest the blocks, thus chaining them together. The last
one in the chain is used to create the dataloader that is required.
""",
# wrap_dps="Wrap any `DataPipe`s in `DataPipeWrapperTransformBlock` in `self.blocks`",
blocks2dp_or_dl="""Passes `source` into single `TransformBlock`s or passes `source`
to chained `TransformBlock` outputs. In either case, it results in a single `DataPipe`. 

If `as_dataloader` is True, then a `DataLoader2` instance is returned instead.
""",
datapipes="""Combines `self.blocks` with `source` where `bs` can be defined. `n=None` means 
that the datapipes are infinite / lengthless. If `n` is an integer then the datapipes will have 
an expected max len.
""",
dataloaders="Returns a dataloader for each respoctive combination of blocks." 
)
