/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidthCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileWithUrl;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileIfDown;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondSquare;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.ConditionEndStyle;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ConditionalBuilder {
    private final Swimlane swimlane;
    private final HColor borderColor;
    private final HColor backColor;
    private final LineBreakStrategy diamondLineBreak;
    private final LineBreakStrategy labelLineBreak;
    private final Rainbow arrowColor;
    private final FtileFactory ftileFactory;
    private final ConditionStyle conditionStyle;
    private final ConditionEndStyle conditionEndStyle;
    private final Branch branch1;
    private final Branch branch2;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final FontConfiguration fontArrow;
    private final FontConfiguration fontTest;
    private final Ftile tile1;
    private final Ftile tile2;
    private final Url url;

    public StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public ConditionalBuilder(Swimlane swimlane, HColor borderColor, HColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, ConditionEndStyle conditionEndStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration fontArrow, FontConfiguration fontTest, Url url) {
        if (UseStyle.useBetaStyle()) {
            Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
            Style styleDiamond = this.getDefaultStyleDefinitionDiamond().getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.diamondLineBreak = styleDiamond.wrapWidth();
            this.labelLineBreak = styleArrow.wrapWidth();
            this.borderColor = styleDiamond.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            this.backColor = styleDiamond.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            this.arrowColor = Rainbow.fromColor(styleArrow.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()), null);
            this.fontTest = styleDiamond.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            this.fontArrow = styleArrow.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        } else {
            this.diamondLineBreak = LineBreakStrategy.NONE;
            this.labelLineBreak = LineBreakStrategy.NONE;
            this.borderColor = borderColor;
            this.backColor = backColor;
            this.arrowColor = arrowColor;
            this.fontTest = fontTest;
            this.fontArrow = fontArrow;
        }
        this.ftileFactory = ftileFactory;
        this.swimlane = swimlane;
        this.conditionStyle = conditionStyle;
        this.conditionEndStyle = conditionEndStyle;
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.url = url;
        this.tile1 = new FtileMinWidthCentered(branch1.getFtile(), 30.0);
        this.tile2 = new FtileMinWidthCentered(branch2.getFtile(), 30.0);
    }

    public static Ftile create(Swimlane swimlane, HColor borderColor, HColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, ConditionEndStyle conditionEndStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration fcArrow, FontConfiguration fcTest, Url url) {
        ConditionalBuilder builder = new ConditionalBuilder(swimlane, borderColor, backColor, arrowColor, ftileFactory, conditionStyle, conditionEndStyle, branch1, branch2, skinParam, stringBounder, fcArrow, fcTest, url);
        if (ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch2) && !ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch1)) {
            return builder.createDown(builder.branch1, builder.branch2);
        }
        if (branch1.isEmpty() && branch2.isOnlySingleStopOrSpot()) {
            return builder.createDown(builder.branch1, builder.branch2);
        }
        if (ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch1) && !ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch2)) {
            return builder.createDown(builder.branch2, builder.branch1);
        }
        if (branch2.isEmpty() && branch1.isOnlySingleStopOrSpot()) {
            return builder.createDown(builder.branch2, builder.branch1);
        }
        return builder.createWithLinks();
    }

    private static boolean isEmptyOrOnlySingleStopOrSpot(Branch branch) {
        return branch.isEmpty() || branch.isOnlySingleStopOrSpot();
    }

    private Ftile createDown(Branch branch1, Branch branch2) {
        FtileMinWidthCentered tile1 = new FtileMinWidthCentered(branch1.getFtile(), 30.0);
        FtileMinWidthCentered tile2 = new FtileMinWidthCentered(branch2.getFtile(), 30.0);
        TextBlock tb1 = this.getLabelPositive(branch1);
        TextBlock tb2 = this.getLabelPositive(branch2);
        Ftile diamond1 = this.getShape1(false, tb1, tb2);
        Ftile diamond2 = this.getShape2(branch1, branch2, true);
        if (branch2.isOnlySingleStopOrSpot()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile1, 10.0), this.arrowColor, this.conditionEndStyle, this.ftileFactory, branch2.getFtile(), branch2.getOut());
        }
        if (branch1.isOnlySingleStopOrSpot()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile2, 10.0), this.arrowColor, this.conditionEndStyle, this.ftileFactory, branch1.getFtile(), branch1.getOut());
        }
        if (branch1.isEmpty()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile2, 10.0), this.arrowColor, this.conditionEndStyle, this.ftileFactory, null, null);
        }
        return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile1, 10.0), this.arrowColor, this.conditionEndStyle, this.ftileFactory, null, branch2.getOut());
    }

    private Ftile createNude() {
        return new FtileIfNude(this.tile1, this.tile2, this.swimlane);
    }

    private Ftile createWithDiamonds() {
        Ftile diamond1 = this.getDiamond1(true);
        Ftile diamond2 = this.getShape2(this.branch1, this.branch2, false);
        FtileIfWithDiamonds ftile = new FtileIfWithDiamonds(diamond1, this.tile1, this.tile2, diamond2, this.swimlane, this.stringBounder);
        Dimension2D label1 = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D label2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double diff1 = ftile.computeMarginNeedForBranchLabe1(this.stringBounder, label1);
        double diff2 = ftile.computeMarginNeedForBranchLabe2(this.stringBounder, label2);
        Ftile result = FtileUtils.addHorizontalMargin(ftile, diff1, diff2);
        double suppHeight = ftile.computeVerticalMarginNeedForBranchs(this.stringBounder, label1, label2);
        result = FtileUtils.addVerticalMargin(result, suppHeight, 0.0);
        return result;
    }

    private Ftile createWithLinks() {
        Ftile diamond1 = this.getDiamond1(true);
        if (this.url != null) {
            diamond1 = new FtileWithUrl(diamond1, this.url);
        }
        Ftile diamond2 = this.getShape2(this.branch1, this.branch2, false);
        Ftile tmp1 = FtileUtils.addHorizontalMargin(this.tile1, 10.0);
        Ftile tmp2 = FtileUtils.addHorizontalMargin(this.tile2, 10.0);
        FtileIfWithLinks ftile = new FtileIfWithLinks(diamond1, tmp1, tmp2, diamond2, this.swimlane, this.arrowColor, this.conditionEndStyle, this.stringBounder);
        Dimension2D label1 = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D label2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double diff1 = ftile.computeMarginNeedForBranchLabe1(this.stringBounder, label1);
        double diff2 = ftile.computeMarginNeedForBranchLabe2(this.stringBounder, label2);
        double suppHeight = ftile.computeVerticalMarginNeedForBranchs(this.stringBounder, label1, label2);
        Ftile result = ftile.addLinks(this.branch1, this.branch2, this.stringBounder);
        result = FtileUtils.addHorizontalMargin(result, diff1, diff2);
        result = FtileUtils.addVerticalMargin(result, suppHeight, 0.0);
        return result;
    }

    private Ftile getDiamond1(boolean eastWest) {
        return this.getShape1(eastWest, this.getLabelPositive(this.branch1), this.getLabelPositive(this.branch2));
    }

    private Ftile getShape1(boolean eastWest, TextBlock tb1, TextBlock tb2) {
        Ftile shape1;
        Display labelTest = this.branch1.getLabelTest();
        Sheet sheet = Parser.build(this.fontTest, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(labelTest);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, this.diamondLineBreak, this.skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Hexagon.asStencil(sheetBlock1), this.tile1.getThickness());
        if (this.conditionStyle == ConditionStyle.INSIDE_HEXAGON) {
            shape1 = eastWest ? new FtileDiamondInside(tbTest, this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withWestAndEast(tb1, tb2) : new FtileDiamondInside(tbTest, this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withSouth(tb1).withEast(tb2);
        } else if (this.conditionStyle == ConditionStyle.EMPTY_DIAMOND) {
            shape1 = eastWest ? new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(tbTest).withWestAndEast(tb1, tb2) : new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(tbTest).withSouth(tb1).withEast(tb2);
        } else if (this.conditionStyle == ConditionStyle.INSIDE_DIAMOND) {
            shape1 = eastWest ? new FtileDiamondSquare(tbTest, this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withWestAndEast(tb1, tb2) : new FtileDiamondSquare(tbTest, this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withSouth(tb1).withEast(tb2);
        } else {
            throw new IllegalStateException();
        }
        return shape1;
    }

    private TextBlock getLabelPositive(Branch branch) {
        return branch.getDisplayPositive().create0(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory.skinParam(), this.labelLineBreak, CreoleMode.SIMPLE_LINE, null, null);
    }

    private Ftile getShape2(Branch branch1, Branch branch2, boolean useNorth) {
        AbstractFtile shape2;
        if (this.conditionEndStyle == ConditionEndStyle.HLINE) {
            return new FtileEmpty(this.tile1.skinParam(), 0.0, 12.0, this.swimlane);
        }
        if (this.hasTwoBranches()) {
            Display out1 = branch1.getFtile().getOutLinkRendering().getDisplay();
            TextBlock tbout1 = out1 == null ? null : out1.create7(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            Display out2 = branch2.getFtile().getOutLinkRendering().getDisplay();
            TextBlock tbout2 = out2 == null ? null : out2.create7(this.fontArrow, HorizontalAlignment.LEFT, this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            FtileDiamond tmp = new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane);
            tmp = useNorth ? tmp.withNorth(tbout1) : tmp.withWest(tbout1);
            tmp = tmp.withEast(tbout2);
            shape2 = tmp;
        } else {
            shape2 = new FtileEmpty(this.tile1.skinParam(), 0.0, 6.0, this.swimlane);
        }
        return shape2;
    }

    public boolean hasTwoBranches() {
        return this.tile1.calculateDimension(this.stringBounder).hasPointOut() && this.tile2.calculateDimension(this.stringBounder).hasPointOut();
    }
}

