"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    /**
     * AWS Proxy Integration Type
     */
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
    /**
     * Mock Integration Type
     */
    WebSocketIntegrationType["MOCK"] = "MOCK";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketIntegration);
            }
            throw error;
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketIntegration", version: "2.44.0-alpha.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class WebSocketRouteIntegration {
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteIntegration", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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