"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketNoneAuthorizer = exports.WebSocketAuthorizer = exports.WebSocketAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported Authorizer types
 */
var WebSocketAuthorizerType;
(function (WebSocketAuthorizerType) {
    /** Lambda Authorizer */
    WebSocketAuthorizerType["LAMBDA"] = "REQUEST";
    /** IAM Authorizer */
    WebSocketAuthorizerType["IAM"] = "AWS_IAM";
})(WebSocketAuthorizerType = exports.WebSocketAuthorizerType || (exports.WebSocketAuthorizerType = {}));
/**
 * An authorizer for WebSocket Apis
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class WebSocketAuthorizer extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketAuthorizer);
            }
            throw error;
        }
        if (props.type === WebSocketAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: props.authorizerName ?? id,
            apiId: props.webSocketApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            authorizerUri: props.authorizerUri,
        });
        this.authorizerId = resource.ref;
    }
    /**
     * Import an existing WebSocket Authorizer into this CDK app.
     */
    static fromWebSocketAuthorizerAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketAuthorizerAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.WebSocketAuthorizer = WebSocketAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketAuthorizer", version: "2.44.0-alpha.0" };
/**
 * Explicitly configure no authorizers on specific WebSocket API routes.
 */
class WebSocketNoneAuthorizer {
    bind(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteAuthorizerBindOptions(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.WebSocketNoneAuthorizer = WebSocketNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
WebSocketNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketNoneAuthorizer", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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