"""
This module contains o!rdr API Error Codes.
"""
from __future__ import annotations

from enum import IntEnum
from enum import unique

__all__ = ("ErrorCode",)


@unique
class ErrorCode(IntEnum):
    NO_ERROR = 0
    EMERGENCY_STOP = 1
    BAD_REPLAY_FILE = 2
    REPLAY_DOWNLOAD_FAILED = 3
    NO_BEATMAP_SERVER = 4
    REPLAY_FILE_CORRUPTED = 5
    INVALID_GAMEMODE = 6
    NO_REPLAY_INPUT_DATA = 7
    NO_BEATMAP_DATA = 8
    NO_BEATMAP_AUDIO = 9
    OSU_API_ERROR = 10
    REPLAY_AUTO_MODE = 11
    REPLAY_INVALID_USERNAME = 12
    BEATMAP_TOO_LONG = 13
    PLAYER_BANNED = 14
    UNKNOWN_BEATMAP = 15
    IP_BANNED = 16
    USERNAME_BANNED = 17
    UNKNOWN_RENDER_ERROR = 18
    RENDER_DOWNLOAD_FAILED = 19
    OLD_BEATMAP_DATA = 20
    REPLAY_PARSE_FAILED = 21
    FAILED_GENERATING_VIDEO = 22
    FAILED_PREPARING_RENDER = 23
    NO_BEATMAP_NAME = 24
    PARTIAL_REPLAY_INPUT_DATA = 25
    REPLAY_INVALID_MODS = 26
    RENDER_GENERAL_ERROR = 27
    RENDER_REPLAY_DOWNLOAD_FAILED = 28
    REPLAY_ALREADY_RENDERED = 29
    STAR_RATING_TOO_HIGH = 30
    MAPPER_BANNED = 31
    BEATMAPSET_BANNED = 32
    REPLAY_RECENT_FAIL = 33
