# Bias-Adjustment-Python
[![Generic badge](https://img.shields.io/badge/license-MIT-green.svg)](https://shields.io/)
[![Generic badge](https://img.shields.io/badge/python-3.7+-blue.svg)](https://shields.io/)
[![GitHub](https://badgen.net/badge/icon/github?icon=github&label)](https://github.com/btschwertfeger/Bias-Adjustment-Python)
Collection of different scale- and distribution-based bias adjustment techniques for climatic research. (see `examples.ipynb` for help)

Bias adjustment procedures in Python are very slow, so they should not be used on large data sets.
A C++ Implementation that works way faster can be found here: [https://github.com/btschwertfeger/Bias-Adjustment-Cpp](https://github.com/btschwertfeger/Bias-Adjustment-Cpp).
____
## Run adjustment:
```bash
python3 do_bias_correction.py   \
    --obs input_data/obs.nc     \
    --contr input_data/contr.nc \
    --scen input_data/scen.nc   \
    --method linear_scaling     \
    --variable tas              \
    --unit '°C'                 \
    --group time.month          \
    --kind + 
```
____
## Methods implemented by Benjamin T. Schwertfeger:
|Method| `--method` parameter|
|-----|-----|
|Linear Scaling| linear_scaling|
|Variance Scaling|variance_scaling|
|Delta Method|delta_method|
|Quantile Mapping|quantile_mapping|
|Quantile Delta Mapping|quantile_delta_mapping|

____
# Notes:
- Linear and variance, as well as delta change method require `--group time.month` as argument.
- Adjustment methods that apply changes in distributional biasses (QM. QDM, DQM; EQM, ...) need the `--nquantiles` argument set to some integer.
- Data sets should have the same spatial resolutions.
- Computation in Python takes some time, so this is only for demonstration. When adjusting large datasets, its best to the C++ implementation mentioned above.