"""Fixes for ACCESS-CM2."""
import iris

from ..common import ClFixHybridHeightCoord


class Cl(ClFixHybridHeightCoord):
    """Fixes for cl."""

    def fix_metadata(self, cubes):
        """Fix hybrid coefficient b, then call fix_metadata from parent.

        Parameters
        ----------
        cubes : iris.cube.CubeList
            Input cubes.

        Returns
        -------
        iris.cube.CubeList

        """
        for cube in cubes:
            try:
                bcoeff = cube.coord(var_name='b')
                # values taken from UK-ESM1-0-LL model, which uses the same
                # atmospheric component as ACCESS-CM2 (MetUM-HadGEM3-GA7.1,
                # N96 (192x144), 85 vertical levels, top = 85 km)
                bcoeff.points = [
                    0.997741281986237, 0.993982434272766, 0.988731920719147,
                    0.982001721858978, 0.973807096481323, 0.964166879653931,
                    0.953103065490723, 0.940641283988953, 0.926810503005981,
                    0.911642968654633, 0.895174443721771, 0.877444267272949,
                    0.858494758605957, 0.838372051715851, 0.81712543964386,
                    0.7948077917099, 0.77147513628006, 0.747187197208405,
                    0.722006916999817, 0.696000635623932, 0.669238269329071,
                    0.641793012619019, 0.613741397857666, 0.585163474082947,
                    0.556142747402191, 0.526765942573547, 0.49712336063385,
                    0.467308610677719, 0.437418729066849, 0.40755420923233,
                    0.377818822860718, 0.348319888114929, 0.319168090820312,
                    0.290477395057678, 0.262365132570267, 0.234952658414841,
                    0.20836341381073, 0.182725623250008, 0.158169254660606,
                    0.134828746318817, 0.112841464579105, 0.0923482477664948,
                    0.0734933465719223, 0.0564245767891407, 0.041294027119875,
                    0.028257654979825, 0.0174774676561356, 0.00912047084420919,
                    0.00336169824004173, 0.000384818413294852,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                ]
                bcoeff.bounds = [
                    [1, 0.995860934257507],
                    [0.995860934257507, 0.991355419158936],
                    [0.991355419158936, 0.985363960266113],
                    [0.985363960266113, 0.977900147438049],
                    [0.977900147438049, 0.968980967998505],
                    [0.968980967998505, 0.958626985549927],
                    [0.958626985549927, 0.946861922740936],
                    [0.946861922740936, 0.93371307849884],
                    [0.93371307849884, 0.919211089611053],
                    [0.919211089611053, 0.903389930725098],
                    [0.903389930725098, 0.886287212371826],
                    [0.886287212371826, 0.867943704128265],
                    [0.867943704128265, 0.848403632640839],
                    [0.848403632640839, 0.827714681625366],
                    [0.827714681625366, 0.805927932262421],
                    [0.805927932262421, 0.783098042011261],
                    [0.783098042011261, 0.75928258895874],
                    [0.75928258895874, 0.734543085098267],
                    [0.734543085098267, 0.708944141864777],
                    [0.708944141864777, 0.682553827762604],
                    [0.682553827762604, 0.655443787574768],
                    [0.655443787574768, 0.627688825130463],
                    [0.627688825130463, 0.599367320537567],
                    [0.599367320537567, 0.570560812950134],
                    [0.570560812950134, 0.541354656219482],
                    [0.541354656219482, 0.511837363243103],
                    [0.511837363243103, 0.482100784778595],
                    [0.482100784778595, 0.452240228652954],
                    [0.452240228652954, 0.422354459762573],
                    [0.422354459762573, 0.392545729875565],
                    [0.392545729875565, 0.362919509410858],
                    [0.362919509410858, 0.333584785461426],
                    [0.333584785461426, 0.304653882980347],
                    [0.304653882980347, 0.276242583990097],
                    [0.276242583990097, 0.248470112681389],
                    [0.248470112681389, 0.221458733081818],
                    [0.221458733081818, 0.195334210991859],
                    [0.195334210991859, 0.170226037502289],
                    [0.170226037502289, 0.146266028285027],
                    [0.146266028285027, 0.123590461909771],
                    [0.123590461909771, 0.102338522672653],
                    [0.102338522672653, 0.0826521068811417],
                    [0.0826521068811417, 0.0646774247288704],
                    [0.0646774247288704, 0.0485646799206734],
                    [0.0485646799206734, 0.0344676785171032],
                    [0.0344676785171032, 0.0225453991442919],
                    [0.0225453991442919, 0.01296216994524],
                    [0.01296216994524, 0.00588912842795253],
                    [0.00588912842795253, 0.00150532135739923],
                    [0.00150532135739923, 0],
                    [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0],
                    [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0],
                    [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0],
                    [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0],
                    [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0],
                ]
            except iris.exceptions.CoordinateNotFoundError:
                pass
        return super().fix_metadata(cubes)


Cli = Cl


Clw = Cl
