
[![N|Python](https://www.python.org/static/community_logos/python-powered-w-100x40.png)](https://www.python.org)
[![CircleCI](https://circleci.com/gh/fusion-energy/paramak/tree/main.svg?style=svg)](https://circleci.com/gh/fusion-energy/paramak/tree/main)
[![codecov](https://codecov.io/gh/fusion-energy/paramak/branch/main/graph/badge.svg)](https://codecov.io/gh/fusion-energy/paramak)
[![PyPI](https://img.shields.io/pypi/v/paramak?color=brightgreen&label=pypi&logo=grebrightgreenen&logoColor=green)](https://pypi.org/project/paramak/)
[![Documentation Status](https://readthedocs.org/projects/paramak/badge/?version=main)](https://paramak.readthedocs.io/en/main/?badge=main)
<!-- [![dockerhub-publish-stable](https://github.com/fusion-energy/paramak/workflows/dockerhub-publish-stable/badge.svg)](https://github.com/fusion-energy/paramak/actions?query=workflow%3Adockerhub-publish-stable) -->
[![DOI](https://zenodo.org/badge/269635577.svg)](https://zenodo.org/badge/latestdoi/269635577)

# Paramak

The Paramak python package allows rapid production of 3D CAD models of fusion
reactors. The purpose of the Paramak is to provide geometry for parametric
studies. The paramak can created geometry in standard CAD formats such as STP,
STL. It can also create h5m files for 
[DAGMC](https://svalinn.github.io/DAGMC/) and carry out neutronics simulations
when used with the optional [paramak-neutronics](https://github.com/fusion-energy/paramak-neutronics)
module.

:point_right: [Documentation](https://paramak.readthedocs.io)

:point_right: [Video presentation](https://www.youtube.com/embed/fXboew3U7rw)

:point_right: [Installation](https://paramak.readthedocs.io/en/main/#system-installation)

:point_right: [Publication](https://f1000research.com/articles/10-27/v1)

:point_right: [Docker images](https://github.com/fusion-energy/paramak/pkgs/container/paramak)



## Citing

If you use the Paramak in your research, please consider giving proper
attribution by citing our [Publication](https://f1000research.com/articles/10-27/v1):

- J. Shimwell, J. Billingsley and R. Delaporte-Mathurin et al. The Paramak: 
  Automated Parametric Geometry Construction for Fusion Reactor Designs.
  F1000Research, vol. 10, Jan. 2021, p. 27. DOI.org (Crossref),
  doi:10.12688/f1000research.28224.1.

    <details>
        <summary>BibTex</summary>
        <pre><code class="language-html">
    @article{paramak,
        title = {The {Paramak}: automated parametric geometry construction for fusion reactor designs.},
        volume = {10},
        issn = {2046-1402},
        shorttitle = {The {Paramak}},
        url = {https://f1000research.com/articles/10-27/v1},
        doi = {10.12688/f1000research.28224.1},
        language = {en},
        urldate = {2021-01-22},
        journal = {F1000Research},
        author = {Shimwell, Jonathan and Billingsley, John and Delaporte-Mathurin, Rémi and Morbey, Declan and Bluteau, Matthew and Shriwise, Patrick and Davis, Andrew},
        month = jan,
        year = {2021},
        pages = {27},
    }
        </code></pre>
    </details>
