import abc
import typing as t
from _typeshed import Incomplete
from hexcore.domain.base import BaseEntity as BaseEntity
from hexcore.domain.events import DomainEvent as DomainEvent
from hexcore.domain.uow import IUnitOfWork as IUnitOfWork
from hexcore.infrastructure.repositories.orms.sqlalchemy import BaseModel as BaseModel
from sqlalchemy.ext.asyncio import AsyncSession as AsyncSession

class SqlAlchemyUnitOfWork(IUnitOfWork, metaclass=abc.ABCMeta):
    session: Incomplete = ...
    def __init__(self, session: AsyncSession) -> None: ...
    async def __aexit__(self, exc_type: type | None, exc_val: BaseException | None, exc_tb: t.Any | None) -> None: ...
    async def commit(self) -> None: ...
    async def rollback(self) -> None: ...
    def collect_domain_entities(self) -> set[BaseEntity]: ...
    def collect_domain_events(self) -> list[DomainEvent]: ...
    async def dispatch_events(self) -> None: ...
    def clear_tracked_entities(self) -> None: ...
    def collect_entity(self, entity: BaseEntity) -> None: ...

class NoSqlUnitOfWork(IUnitOfWork, metaclass=abc.ABCMeta):
    def __init__(self) -> None: ...
    async def __aenter__(self): ...
    async def __aexit__(self, exc_type: type | None, exc_val: BaseException | None, exc_tb: t.Any | None) -> None: ...
    async def commit(self) -> None: ...
    async def rollback(self) -> None: ...
    def collect_entity(self, entity: BaseEntity): ...
    def collect_domain_entities(self) -> set[BaseEntity]: ...
    def collect_domain_events(self) -> list[DomainEvent]: ...
    async def dispatch_events(self) -> None: ...
    def clear_tracked_entities(self) -> None: ...
