import types
import typing as t
from . import BaseModel as BaseModel
from hexcore.domain.base import BaseEntity as BaseEntity
from hexcore.types import FieldResolversType as FieldResolversType, RelationsType as RelationsType
from sqlalchemy.ext.asyncio import AsyncSession as AsyncSession
from uuid import UUID

T = t.TypeVar('T', bound=BaseModel[t.Any])
E = t.TypeVar('E', bound=BaseEntity)

def to_model(entity: E, model_cls: type[T], exclude: set[str] | None = ..., field_serializers: FieldResolversType[E] | None = ..., set_domain: bool = ...) -> T: ...
def load_relations(model: type[T]) -> t.Any: ...
async def db_get(session: AsyncSession, model: type[T], id: UUID, exc_none: Exception) -> T: ...
async def db_list(session: AsyncSession, model: type[T]) -> list[T]: ...
async def db_save(session: AsyncSession, entity: T) -> T: ...
def select_in_load_options(*relationships: str, model: type[T]) -> t.Any: ...
async def assign_relations(session: AsyncSession, model_instance: BaseModel[t.Any], relations: RelationsType) -> None: ...
async def save_entity(session: AsyncSession, entity: E, model_cls: type[T], relations: RelationsType | None = ..., exclude: set[str] | None = ..., fields_serializers: FieldResolversType[E] | None = ...) -> T: ...
async def logical_delete(session: AsyncSession, entity: BaseEntity, model_cls: type[T]) -> None: ...
def import_all_models(package: types.ModuleType) -> t.Any: ...
