import typing as t
from . import BaseDocument as BaseDocument
from hexcore.config import LazyConfig as LazyConfig
from hexcore.domain.base import BaseEntity as BaseEntity
from hexcore.infrastructure.repositories.utils import get_all_concrete_subclasses as get_all_concrete_subclasses
from hexcore.types import FieldSerializersType as FieldSerializersType
from uuid import UUID

E = t.TypeVar('E', bound=BaseEntity)
D = t.TypeVar('D', bound=BaseDocument)

def to_document(entity_data: E, document_class: type[D], field_serializers: FieldSerializersType[E] | None = ..., update: bool = ...) -> D: ...
def discover_beanie_documents() -> list[type[BaseDocument]]: ...
async def init_beanie_documents() -> None: ...
async def db_get(document_class: type[D], entity_id: UUID) -> D | None: ...
async def db_list(document_class: type[D]) -> list[D]: ...
async def save_entity(entity: E, document_cls: type[D], fields_serializers: FieldSerializersType[E]) -> D: ...
async def logical_delete(entity_id: UUID, document_cls: type[D]) -> None: ...
