import abc
import typing as t
from hexcore.domain.base import BaseEntity as BaseEntity

T = t.TypeVar('T', bound=BaseEntity)

class IUnitOfWork(abc.ABC, metaclass=abc.ABCMeta):
    repositories: dict[str, t.Any] = ...
    events_dispatcher: t.Any = ...
    def __init__(self) -> None: ...
    async def __aenter__(self) -> IUnitOfWork: ...
    async def __aexit__(self, exc_type: type | None, exc_val: BaseException | None, exc_tb: t.Any | None) -> None: ...
    @abc.abstractmethod
    def IUnitOfWork(self) -> set[BaseEntity]: ...
    @abc.abstractmethod
    def collect_domain_events(self) -> list[t.Any]: ...
    @abc.abstractmethod
    async def dispatch_events(self) -> None: ...
    @abc.abstractmethod
    def clear_tracked_entities(self) -> None: ...
    @abc.abstractmethod
    async def commit(self) -> None: ...
    @abc.abstractmethod
    async def rollback(self) -> None: ...
    @abc.abstractmethod
    def collect_entity(self, entity: BaseEntity) -> None: ...
