import abc
import typing as t
from .base import BaseEntity as BaseEntity
from _typeshed import Incomplete
from datetime import datetime
from pydantic import BaseModel, computed_field
from uuid import UUID

T = t.TypeVar('T', bound=BaseEntity)

class DomainEvent(BaseModel):
    event_id: UUID = ...
    occurred_on: datetime = ...
    @computed_field
    @property
    def event_name(self) -> str: ...
    model_config: Incomplete = ...

class EntityCreatedEvent(DomainEvent, t.Generic[T]):
    entity_id: UUID = ...
    entity_data: T = ...

class EntityUpdatedEvent(DomainEvent, t.Generic[T]):
    entity_id: UUID = ...
    entity_data: T = ...

class EntityDeletedEvent(DomainEvent):
    entity_id: UUID = ...
EventHandler = t.Callable[[DomainEvent], t.Awaitable[None]]

class IEventDispatcher(abc.ABC, metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def register(self, event_type: type, handler: EventHandler) -> None: ...
    @abc.abstractmethod
    async def dispatch(self, event: t.Any) -> None: ...
