#!/usr/bin/env python
# encoding: utf-8
"""
Predictor.py

Created by Wim Vranken on 1st May 2020, as wrapper around original PSPer code
Note that the original DisoMine code was upgraded to Python3.7 and simplified by taking out redundant code for production version
The DisoMine code was also modified to better work in conjunction with the data structures used here.
Copyright (c) 2020- Wim Vranken. All rights reserved.
"""

from b2bTools.general.Io import B2bIo
from b2bTools.singleSeq.PSPer.standalone import standalone

class PSPer(B2bIo):

  version = '1.0'
  scriptName = "b2bTools.singleSeq.PSPer.Predictor"
  name ="PSPer"

  def __init__(self):
    # Additional info for writing files
    self.references = ['Not yet available, submitted']
    self.infoTexts = ['Generated by PSPer', 'See http://bio2byte.be']

    self.informationPerPredictor = {
      self.name: {
        'references': self.references,
        'info':       ";".join(self.infoTexts),
        'version':    self.version,
        'origin':     self.scriptName
      }
    }

  # Warning: THIS IS NOW NOT WORKING FROM A DICT BUT FROM A LIST OF TUPLES!
  def predictSeqs(self, seqs):
      PSPerResults = standalone(seqs)
      if not PSPerResults:
          print("PSPer failed....")
